/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleWithMaxFilter;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternTokenMatcher;
import org.languagetool.rules.patterns.RuleFilterEvaluator;
import org.languagetool.rules.patterns.RuleMatcher;
import org.languagetool.tools.StringTools;

public final class PatternRuleMatcher
extends AbstractPatternRulePerformer
implements RuleMatcher {
    public static final String MISTAKE = "<mistake/>";
    private static final Map<String, Integer> currentlyActiveRules = new ConcurrentHashMap<String, Integer>();
    private static final String SUGGESTION_START_TAG = "<suggestion>";
    private static final String SUGGESTION_END_TAG = "</suggestion>";
    private static final String allowedChars = "[^<>()]*?";
    private static final Pattern SUGGESTION_PATTERN_SUPPRESS = Pattern.compile("<suggestion><pleasespellme/>[^<>()]*?(\\([^<>()]*?\\)|<mistake/>)[^<>()]*?</suggestion>");
    private final boolean useList;
    private static final boolean monitorRules = System.getProperty("monitorActiveRules") != null;

    PatternRuleMatcher(PatternRule rule, boolean useList) {
        super(rule, rule.getLanguage().getUnifier());
        this.useList = useList;
    }

    public static Map<String, Integer> getCurrentRules() {
        return currentlyActiveRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        String key;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String string = key = monitorRules ? this.rule.getFullId() + ": " + sentence.getText() : null;
        if (key != null) {
            currentlyActiveRules.compute(key, (k, v) -> v == null ? 1 : v + 1);
        }
        try {
            AnalyzedTokenReadings[] tokens = this.isInterpretPosTagsPreDisambiguation() ? sentence.getPreDisambigTokensWithoutWhitespace() : sentence.getTokensWithoutWhitespace();
            this.doMatch(sentence, tokens, (tokenPositions, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken) -> {
                RuleMatch ruleMatch = this.createRuleMatch(tokenPositions, tokens, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken, sentence);
                if (ruleMatch != null) {
                    ruleMatches.add(ruleMatch);
                }
            });
            RuleWithMaxFilter maxFilter = new RuleWithMaxFilter();
            List<RuleMatch> filteredMatches = maxFilter.filter(ruleMatches);
            RuleMatch[] ruleMatchArray = filteredMatches.toArray(RuleMatch.EMPTY_ARRAY);
            return ruleMatchArray;
        }
        finally {
            if (key != null) {
                currentlyActiveRules.computeIfPresent(key, (k, v) -> v - 1 > 0 ? Integer.valueOf(v - 1) : null);
            }
        }
    }

    @Override
    protected boolean testAllReadings(AnalyzedTokenReadings[] tokens, PatternTokenMatcher matcher, PatternTokenMatcher prevElement, int tokenNo, int firstMatchToken, int prevSkipNext) throws IOException {
        if (tokens[tokenNo].isImmunized()) {
            return false;
        }
        return super.testAllReadings(tokens, matcher, prevElement, tokenNo, firstMatchToken, prevSkipNext);
    }

    @Nullable
    private RuleMatch createRuleMatch(int[] tokenPositions, AnalyzedTokenReadings[] tokens, int firstMatchToken, int lastMatchToken, int firstMarkerMatchToken, int lastMarkerMatchToken, AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings token;
        int toPos;
        AnalyzedTokenReadings firstMatchTokenObj;
        boolean startsWithUppercase;
        int idx;
        PatternRule rule = (PatternRule)this.rule;
        String errMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, rule.getMessage(), rule.getSuggestionMatches());
        String shortErrMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, rule.getShortMessage(), rule.getSuggestionMatches());
        String suggestionsOutMsg = this.formatMatches(tokens, tokenPositions, firstMatchToken, rule.getSuggestionsOutMsg(), rule.getSuggestionMatchesOutMsg());
        int correctedStPos = 0;
        if (rule.startPositionCorrection > 0) {
            for (int l = 0; l <= Math.min(rule.startPositionCorrection, tokenPositions.length - 1); ++l) {
                correctedStPos += tokenPositions[l];
            }
            --correctedStPos;
        }
        if ((idx = firstMatchToken + correctedStPos) >= tokens.length) {
            idx = tokens.length - 1;
        }
        boolean bl = startsWithUppercase = StringTools.startsWithUppercase((firstMatchTokenObj = tokens[idx]).getToken()) && this.matchPreservesCase(rule.getSuggestionMatches(), rule.getMessage()) && this.matchPreservesCase(rule.getSuggestionMatchesOutMsg(), rule.getSuggestionsOutMsg());
        if (firstMatchTokenObj.isSentenceStart() && tokens.length > firstMatchToken + correctedStPos + 1) {
            firstMatchTokenObj = tokens[firstMatchToken + correctedStPos + 1];
            startsWithUppercase = StringTools.startsWithUppercase(firstMatchTokenObj.getToken());
        }
        if (firstMarkerMatchToken == -1) {
            firstMarkerMatchToken = firstMatchToken;
        }
        int fromPos = tokens[firstMarkerMatchToken].getStartPos();
        if (firstMarkerMatchToken >= 1 && (errMessage.contains("<suggestion>,") || suggestionsOutMsg.contains("<suggestion>,"))) {
            fromPos = tokens[firstMarkerMatchToken - 1].getStartPos() + tokens[firstMarkerMatchToken - 1].getToken().length();
        }
        if (lastMarkerMatchToken == -1) {
            lastMarkerMatchToken = lastMatchToken;
        }
        if (fromPos < (toPos = (token = tokens[Math.min(lastMarkerMatchToken, tokens.length - 1)]).getEndPos()) && (!errMessage.contains("<pleasespellme/>") || errMessage.contains(SUGGESTION_START_TAG) || suggestionsOutMsg.contains(SUGGESTION_START_TAG))) {
            String clearMsg = errMessage.replaceAll("<pleasespellme/>", "").replaceAll(MISTAKE, "");
            RuleMatch ruleMatch = new RuleMatch(rule, sentence, fromPos, toPos, tokens[firstMatchToken].getStartPos(), tokens[lastMatchToken].getEndPos(), clearMsg, shortErrMessage, startsWithUppercase, suggestionsOutMsg);
            ITSIssueType issueType = ruleMatch.getRule().getLocQualityIssueType();
            if (issueType == ITSIssueType.Style || issueType == ITSIssueType.LocaleViolation || issueType == ITSIssueType.Register) {
                ruleMatch.setType(RuleMatch.Type.Hint);
            }
            if (rule.getFilter() != null) {
                RuleFilterEvaluator evaluator = new RuleFilterEvaluator(rule.getFilter());
                AnalyzedTokenReadings[] patternTokens = Arrays.copyOfRange(tokens, firstMatchToken, lastMatchToken + 1);
                return evaluator.runFilter(rule.getFilterArguments(), ruleMatch, patternTokens, firstMatchToken, Ints.asList((int[])tokenPositions));
            }
            return ruleMatch;
        }
        return null;
    }

    private boolean matchPreservesCase(List<Match> suggestionMatches, String msg) {
        if (suggestionMatches != null && !suggestionMatches.isEmpty()) {
            int sugStart = msg.indexOf(SUGGESTION_START_TAG) + SUGGESTION_START_TAG.length();
            if (msg.contains("<pleasespellme/>")) {
                sugStart += "<pleasespellme/>".length();
            }
            for (Match sMatch : suggestionMatches) {
                if (sMatch.isInMessageOnly() || !sMatch.convertsCase() || msg.charAt(sugStart) != '\\') continue;
                return false;
            }
        }
        return true;
    }

    @Override
    int translateElementNo(int i) {
        if (!this.useList || i < 0) {
            return i;
        }
        int j = 0;
        PatternRule rule = (PatternRule)this.rule;
        for (int k = 0; k < i; ++k) {
            j += rule.getElementNo().get(k).intValue();
        }
        return j;
    }

    private String formatMatches(AnalyzedTokenReadings[] tokenReadings, int[] positions, int firstMatchTok, String errorMsg, List<Match> suggestionMatches) throws IOException {
        String errorMessage = errorMsg;
        int matchCounter = 0;
        int[] numbersToMatches = new int[errorMsg.length()];
        boolean newWay = false;
        int errLen = errorMessage.length();
        int errorMessageProcessed = 0;
        int errMarker = errorMessage.indexOf(92, errorMessageProcessed);
        boolean numberFollows = false;
        if (errMarker >= 0 && errMarker < errLen - 1) {
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        while (errMarker >= 0 && numberFollows) {
            int backslashPos = errorMessage.indexOf(92, errorMessageProcessed);
            if (backslashPos >= 0 && StringTools.isPositiveNumber(errorMessage.charAt(backslashPos + 1))) {
                int numLen = 1;
                while (backslashPos + numLen < errorMessage.length() && Character.isDigit(errorMessage.charAt(backslashPos + numLen))) {
                    ++numLen;
                }
                int j = Integer.parseInt(errorMessage.substring(backslashPos + 1, backslashPos + numLen)) - 1;
                int repTokenPos = 0;
                int nextTokenPos = 0;
                for (int l = 0; l <= Math.min(j, positions.length - 1); ++l) {
                    repTokenPos += positions[l];
                }
                if (j + 1 < positions.length) {
                    nextTokenPos = firstMatchTok + repTokenPos + positions[j + 1];
                }
                if (suggestionMatches != null && suggestionMatches.size() > 0) {
                    if (matchCounter < suggestionMatches.size()) {
                        numbersToMatches[j] = matchCounter;
                        String[] matches = j >= positions.length ? this.concatMatches(matchCounter, j, firstMatchTok + repTokenPos, tokenReadings, nextTokenPos, suggestionMatches) : (positions[j] != 0 ? this.concatMatches(matchCounter, j, firstMatchTok + repTokenPos, tokenReadings, nextTokenPos, suggestionMatches) : new String[]{""});
                        String leftSide = errorMessage.substring(0, backslashPos);
                        String rightSide = errorMessage.substring(backslashPos + numLen);
                        if (matches.length == 1) {
                            if (matches[0].isEmpty()) {
                                errorMessage = PatternRuleMatcher.concatWithoutExtraSpace(leftSide, rightSide);
                                errorMessageProcessed = leftSide.length();
                            } else {
                                errorMessage = leftSide + matches[0] + rightSide;
                                errorMessageProcessed = leftSide.length() + matches[0].length();
                            }
                        } else {
                            errorMessage = PatternRuleMatcher.formatMultipleSynthesis(matches, leftSide, rightSide);
                        }
                        ++matchCounter;
                        newWay = true;
                    } else {
                        suggestionMatches.add(suggestionMatches.get(numbersToMatches[j]));
                    }
                }
                if (!newWay) {
                    int newErrorMessageProcessed = errorMessage.lastIndexOf("\\" + (j + 1)) + tokenReadings[firstMatchTok + repTokenPos - 1].getToken().length();
                    errorMessage = errorMessage.substring(0, errorMessageProcessed) + errorMessage.substring(errorMessageProcessed).replace("\\" + (j + 1), tokenReadings[firstMatchTok + repTokenPos - 1].getToken());
                    errorMessageProcessed = newErrorMessageProcessed;
                }
            }
            errMarker = errorMessage.indexOf(92, errorMessageProcessed);
            numberFollows = false;
            errLen = errorMessage.length();
            if (errMarker < 0 || errMarker >= errLen - 1) continue;
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        return PatternRuleMatcher.removeSuppressMisspelled(errorMessage);
    }

    private static String concatWithoutExtraSpace(String leftSide, String rightSide) {
        if (leftSide.endsWith(" ") && rightSide.matches("[\\s,:;.!?].*")) {
            return leftSide.substring(0, leftSide.length() - 1) + rightSide;
        }
        if (leftSide.endsWith("suggestion>") && rightSide.startsWith(" ")) {
            return leftSide + rightSide.substring(1);
        }
        return leftSide + rightSide;
    }

    private static String removeSuppressMisspelled(String s) {
        String result = s;
        Matcher matcher = SUGGESTION_PATTERN_SUPPRESS.matcher(result);
        result = matcher.replaceAll("");
        result = result.replaceAll("<suggestion><pleasespellme/>", SUGGESTION_START_TAG);
        return result;
    }

    static String formatMultipleSynthesis(String[] matches, String leftSide, String rightSide) {
        String suggestionLeft = "";
        String suggestionRight = "";
        String rightSideNew = rightSide;
        int sPos = leftSide.lastIndexOf(SUGGESTION_START_TAG);
        if (sPos >= 0) {
            suggestionLeft = leftSide.substring(sPos + SUGGESTION_START_TAG.length());
        }
        String errorMessage = StringTools.isEmpty(suggestionLeft) ? leftSide : leftSide.substring(0, leftSide.lastIndexOf(SUGGESTION_START_TAG)) + SUGGESTION_START_TAG;
        int rPos = rightSide.indexOf(SUGGESTION_END_TAG);
        if (rPos >= 0) {
            suggestionRight = rightSide.substring(0, rPos);
        }
        if (!StringTools.isEmpty(suggestionRight)) {
            rightSideNew = rightSide.substring(rightSide.indexOf(SUGGESTION_END_TAG));
        }
        int lastLeftSugEnd = leftSide.indexOf(SUGGESTION_END_TAG);
        int lastLeftSugStart = leftSide.lastIndexOf(SUGGESTION_START_TAG);
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        for (int z = 0; z < matches.length; ++z) {
            sb.append(suggestionLeft);
            sb.append(matches[z]);
            sb.append(suggestionRight);
            if (z >= matches.length - 1 || lastLeftSugEnd >= lastLeftSugStart) continue;
            sb.append(SUGGESTION_END_TAG);
            sb.append(", ");
            sb.append(SUGGESTION_START_TAG);
        }
        sb.append(rightSideNew);
        return sb.toString();
    }

    private String[] concatMatches(int start, int index, int tokenIndex, AnalyzedTokenReadings[] tokens, int nextTokenPos, List<Match> suggestionMatches) throws IOException {
        int len = this.phraseLen(index);
        Language language = this.rule.language;
        if (len != 1) {
            ArrayList<String[]> matchList = new ArrayList<String[]>();
            for (int i = 0; i < len; ++i) {
                int skippedTokens = nextTokenPos - (tokenIndex + i);
                MatchState matchState = suggestionMatches.get(start).createState(language.getSynthesizer(), tokens, tokenIndex - 1 + i, skippedTokens);
                matchList.add(matchState.toFinalString(language));
            }
            return PatternRuleMatcher.combineLists((String[][])matchList.toArray((T[])new String[matchList.size()][]), new String[matchList.size()], 0, language);
        }
        int skippedTokens = nextTokenPos - tokenIndex;
        MatchState matchState = suggestionMatches.get(start).createState(language.getSynthesizer(), tokens, tokenIndex - 1, skippedTokens);
        String[] finalMatch = matchState.toFinalString(language);
        return finalMatch;
    }

    private int phraseLen(int i) {
        PatternRule rule = (PatternRule)this.rule;
        List<Integer> elementNo = rule.getElementNo();
        if (!this.useList || i > elementNo.size() - 1) {
            return 1;
        }
        return elementNo.get(i);
    }

    private static String[] combineLists(String[][] input, String[] output, int r, Language lang) {
        ArrayList<String> outputList = new ArrayList<String>();
        if (r == input.length) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < output.length; ++k) {
                sb.append(output[k]);
                if (k >= output.length - 1) continue;
                sb.append(StringTools.addSpace(output[k + 1], lang));
            }
            outputList.add(sb.toString());
        } else {
            for (int c = 0; c < input[r].length; ++c) {
                output[r] = input[r][c];
                String[] sList = PatternRuleMatcher.combineLists(input, output, r + 1, lang);
                outputList.addAll(Arrays.asList(sList));
            }
        }
        return outputList.toArray(new String[0]);
    }
}

