/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.net.MalformedURLException;
import java.net.URL;
import org.luwrain.core.NullCheck;

public final class AudioFragment {
    public final String src;
    public final long beginPos;
    public final long endPos;

    public AudioFragment(String src, long beginPos) {
        NullCheck.notNull((Object)src, (String)"src");
        this.src = src;
        this.beginPos = beginPos;
        this.endPos = -1L;
    }

    public AudioFragment(String src) {
        NullCheck.notNull((Object)src, (String)"src");
        this.src = src;
        this.beginPos = -1L;
        this.endPos = -1L;
    }

    public AudioFragment(String src, long beginPos, long endPos) {
        NullCheck.notNull((Object)src, (String)"src");
        this.src = src;
        this.beginPos = beginPos;
        this.endPos = endPos;
    }

    public long beginPosMsec() {
        return this.beginPos;
    }

    public long endPosMsec() {
        return this.endPos;
    }

    public boolean covers(String audioFileUrl, long msec) {
        if (!this.src.equals(audioFileUrl)) {
            return false;
        }
        if (this.endPos < 0L) {
            return msec >= this.beginPos;
        }
        return msec >= this.beginPos && msec <= this.endPos;
    }

    public boolean covers(String audioFileUrl, long msec, URL baseUrl) {
        NullCheck.notNull((Object)baseUrl, (String)"baseUrl");
        try {
            if (!new URL(baseUrl, this.src).toString().equals(new URL(baseUrl, audioFileUrl).toString())) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        if (this.endPos < 0L) {
            return msec >= this.beginPos;
        }
        return msec >= this.beginPos && msec <= this.endPos;
    }

    public String toString() {
        return "Audio: " + this.src + " (from " + this.beginPos + ", to " + this.endPos + ")";
    }
}

