/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.util.LinkedList;
import org.luwrain.app.reader.books.Book;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.ListItem;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;
import org.luwrain.reader.Visitor;

class SectionsVisitor
implements Visitor {
    private final LinkedList<Book.Section> sections = new LinkedList();

    SectionsVisitor() {
    }

    @Override
    public void visit(Section node) {
        NullCheck.notNull((Object)node, (String)"node");
        LinkedList<String> hrefs = new LinkedList<String>();
        SectionsVisitor.collectHrefs(node, hrefs);
        if (!hrefs.isEmpty()) {
            this.sections.add(new Book.Section(node.getSectionLevel(), node.getCompleteText().trim(), hrefs.getFirst()));
        }
    }

    Book.Section[] getBookSections() {
        return this.sections.toArray(new Book.Section[this.sections.size()]);
    }

    @Override
    public void visitNode(Node node) {
    }

    @Override
    public void visit(ListItem node) {
    }

    @Override
    public void visit(Paragraph node) {
    }

    @Override
    public void visit(TableCell node) {
    }

    @Override
    public void visit(Table node) {
    }

    @Override
    public void visit(TableRow node) {
    }

    private static void collectHrefs(Node node, LinkedList<String> hrefs) {
        NullCheck.notNull((Object)node, (String)"node");
        NullCheck.notNull(hrefs, (String)"hrefs");
        if (node instanceof Paragraph) {
            Paragraph para = (Paragraph)node;
            for (Run r : para.getRuns()) {
                if (r.href() == null || r.href().isEmpty()) continue;
                hrefs.add(r.href());
            }
        } else {
            for (Node n : node.getSubnodes()) {
                SectionsVisitor.collectHrefs(n, hrefs);
            }
        }
    }
}

