/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.reader.ReaderArea;
import org.luwrain.controls.reader.Strings;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.reader.ListItem;
import org.luwrain.reader.Node;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;
import org.luwrain.reader.view.Iterator;

public class DefaultAnnouncement
implements ReaderArea.Announcement {
    protected final ControlContext context;
    protected final TextPreprocessor textPreprocessor;
    protected final Strings strings;

    public DefaultAnnouncement(ControlContext context, TextPreprocessor textPreprocessor, Strings strings) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)textPreprocessor, (String)"textPreprocessor");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.context = context;
        this.textPreprocessor = textPreprocessor;
        this.strings = strings;
    }

    public DefaultAnnouncement(ControlContext context, Strings strings) {
        this(context, text -> context.getSpeakableText(text, Luwrain.SpeakableTextType.NATURAL), strings);
    }

    @Override
    public void announce(Iterator it, boolean briefIntroduction) {
        NullCheck.notNull((Object)it, (String)"it");
        if (it.noContent()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
            return;
        }
        if (it.getNode() == null) {
            this.context.say(it.getText());
            return;
        }
        Node node = this.getDominantNode(it);
        if (node != null) {
            if (node instanceof TableCell) {
                this.onTableCell(it, (TableCell)node);
            } else if (node instanceof ListItem) {
                this.onListItem(it, (ListItem)node);
            } else if (node instanceof Section) {
                this.onSection(it, (Section)node);
            } else {
                this.announceText(it);
            }
            return;
        }
        this.announceText(it);
    }

    protected void onTableCell(Iterator it, TableCell cell) {
        NullCheck.notNull((Object)it, (String)"it");
        NullCheck.notNull((Object)cell, (String)"cell");
        TableRow row = (TableRow)cell.getParentNode();
        int rowIndex = cell.getRowIndex();
        int colIndex = cell.getColIndex();
        if (rowIndex == 0 && colIndex == 0) {
            this.context.say(this.textPreprocessor.preprocess(row.getCompleteText()) + " \u041d\u0430\u0447\u0430\u043b\u043e \u0442\u0430\u0431\u043b\u0438\u0446\u044b", Sounds.TABLE_CELL);
            return;
        }
        if (colIndex == 0) {
            this.context.say(this.textPreprocessor.preprocess(row.getCompleteText()) + " \u0441\u0442\u0440\u043e\u043a\u0430 " + (rowIndex + 1), Sounds.TABLE_CELL);
            return;
        }
        this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.TABLE_CELL, (String)(this.textPreprocessor.preprocess(it.getText()) + " \u0441\u0442\u043e\u043b\u0431\u0435\u0446 " + String.valueOf(colIndex + 1))));
    }

    protected void onListItem(Iterator it, ListItem listItem) {
        NullCheck.notNull((Object)it, (String)"it");
        NullCheck.notNull((Object)listItem, (String)"listItem");
        this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.LIST_ITEM, (String)it.getText()));
    }

    protected void onSection(Iterator it, Section sect) {
        NullCheck.notNull((Object)it, (String)"it");
        NullCheck.notNull((Object)sect, (String)"sect");
        this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.DOC_SECTION, (String)this.textPreprocessor.preprocess(it.getText())));
    }

    protected void announceText(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        String text = it.getText().trim();
        if (text.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint((Hint)Hint.EMPTY_LINE));
            return;
        }
        if (it.getIndexInParagraph() == 0) {
            this.context.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.PARAGRAPH, (String)this.textPreprocessor.preprocess(text)));
        } else {
            this.context.setEventResponse(DefaultEventResponse.text((String)this.textPreprocessor.preprocess(text)));
        }
    }

    protected Node getDominantNode(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        Node res = this.findDominantNode(it);
        if (res == null) {
            return null;
        }
        if (res instanceof TableRow) {
            if (!res.noSubnodes()) {
                return res.getSubnode(0);
            }
            return res;
        }
        if (res instanceof Table) {
            if (!res.noSubnodes() && !res.getSubnode(0).noSubnodes()) {
                return res.getSubnode(0).getSubnode(0);
            }
            return res;
        }
        if (res.getType() == Node.Type.ORDERED_LIST || res.getType() == Node.Type.UNORDERED_LIST) {
            if (res.getSubnodeCount() > 0) {
                return res.getSubnode(0);
            }
            return res;
        }
        return res;
    }

    protected Node findDominantNode(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        if (it.getIndexInParagraph() != 0) {
            return null;
        }
        Node node = it.getNode();
        if (node.getIndexInParentSubnodes() != 0) {
            return node;
        }
        for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getIndexInParentSubnodes() == 0) continue;
            return node;
        }
        return null;
    }

    public static interface TextPreprocessor {
        public String preprocess(String var1);
    }
}

