/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader;

import org.luwrain.controls.reader.ReaderArea;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.view.Iterator;
import org.luwrain.reader.view.Row;

public class DefaultTransition
implements ReaderArea.Transition {
    @Override
    public boolean transition(ReaderArea.Transition.Type type, Iterator it) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)it, (String)"it");
        switch (type) {
            case NEXT: {
                return this.onNext(it);
            }
            case PREV: {
                return this.onPrev(it);
            }
            case STRICT_NEXT: {
                return it.moveNext();
            }
            case STRICT_PREV: {
                return it.movePrev();
            }
            case NEXT_SECTION: 
            case NEXT_SECTION_SAME_LEVEL: {
                return this.onNextSection(it, type == ReaderArea.Transition.Type.NEXT_SECTION_SAME_LEVEL);
            }
            case PREV_SECTION: 
            case PREV_SECTION_SAME_LEVEL: {
                return this.onPrevSection(it, type == ReaderArea.Transition.Type.NEXT_SECTION_SAME_LEVEL);
            }
            case NEXT_PARAGRAPH: {
                return this.onNextParagraph(it);
            }
            case PREV_PARAGRAPH: {
                return this.onPrevParagraph(it);
            }
        }
        return false;
    }

    boolean onNext(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        TableCell tableCell = this.isTableCellIntroRow(it);
        if (tableCell != null && this.onTableDown(tableCell, it)) {
            return true;
        }
        return it.searchForward((node, para, row) -> para != null, it.getIndex() + 1);
    }

    boolean onPrev(Iterator it) {
        if (it.getIndex() == 0) {
            return false;
        }
        NullCheck.notNull((Object)it, (String)"it");
        TableCell tableCell = this.isTableCellIntroRow(it);
        if (tableCell != null && this.onTableUp(tableCell, it)) {
            return true;
        }
        return it.searchBackward((node, para, row) -> para != null, it.getIndex() - 1);
    }

    protected boolean onNextSection(Iterator it, boolean sameLevel) {
        int currentSectLevel;
        Node currentNode = it.getNode();
        if (currentNode == null) {
            return false;
        }
        if (currentNode instanceof Section) {
            Section sect = (Section)currentNode;
            currentSectLevel = sect.getSectionLevel();
        } else {
            currentSectLevel = -1;
        }
        return !(!sameLevel || currentSectLevel < 0 ? !it.searchForward((node, para, row) -> {
            if (node == currentNode) {
                return false;
            }
            return node.getType() == Node.Type.SECTION;
        }, it.getIndex()) : !it.searchForward((node, para, row) -> {
            if (node == currentNode) {
                return false;
            }
            if (node.getType() != Node.Type.SECTION) {
                return false;
            }
            Section sect = (Section)node;
            return sect.getSectionLevel() <= currentSectLevel;
        }, it.getIndex()));
    }

    protected boolean onPrevSection(Iterator it, boolean sameLevel) {
        int currentSectLevel;
        NullCheck.notNull((Object)it, (String)"it");
        Node currentNode = it.getNode();
        if (currentNode == null) {
            return false;
        }
        if (currentNode instanceof Section) {
            Section sect = (Section)currentNode;
            currentSectLevel = sect.getSectionLevel();
        } else {
            currentSectLevel = -1;
        }
        return !(!sameLevel || currentSectLevel < 0 ? !it.searchBackward((node, para, row) -> {
            if (node == currentNode || row.getRelNum() > 0) {
                return false;
            }
            return node.getType() == Node.Type.SECTION;
        }, it.getIndex()) : !it.searchBackward((node, para, row) -> {
            if (node == currentNode || row.getRelNum() > 0) {
                return false;
            }
            if (node.getType() != Node.Type.SECTION) {
                return false;
            }
            Section sect = (Section)node;
            return sect.getSectionLevel() <= currentSectLevel;
        }, it.getIndex()));
    }

    protected boolean onNextParagraph(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        return it.searchForward((node, para, row) -> row.getRelNum() == 0, it.getIndex() + 1);
    }

    protected boolean onPrevParagraph(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        if (it.getIndex() == 0) {
            return false;
        }
        return it.searchBackward((node, para, row) -> row.getRelNum() == 0, it.getIndex() - 1);
    }

    boolean onTableDown(TableCell tableCell, Iterator it) {
        NullCheck.notNull((Object)tableCell, (String)"tableCell");
        NullCheck.notNull((Object)it, (String)"it");
        Table table = tableCell.getTable();
        int rowIndex = tableCell.getRowIndex();
        int colIndex = tableCell.getColIndex();
        if (rowIndex + 1 >= table.getRowCount()) {
            return it.searchForward((node, para, row) -> !node.isInTable(table) && !node.noText(), it.getIndex() + 1);
        }
        TableCell newCell = table.getCell(colIndex, rowIndex + 1);
        if (newCell == null) {
            return false;
        }
        return this.findTableCellForward(newCell, it);
    }

    boolean onTableUp(TableCell tableCell, Iterator it) {
        NullCheck.notNull((Object)tableCell, (String)"tableCell");
        NullCheck.notNull((Object)it, (String)"it");
        Table table = tableCell.getTable();
        int rowIndex = tableCell.getRowIndex();
        int colIndex = tableCell.getColIndex();
        if (rowIndex == 0) {
            return false;
        }
        TableCell newCell = table.getCell(colIndex, rowIndex - 1);
        if (newCell == null) {
            return false;
        }
        return this.findTableCellBackward(newCell, it);
    }

    protected boolean findTableCellForward(TableCell tableCell, Iterator it) {
        NullCheck.notNull((Object)tableCell, (String)"tableCell");
        NullCheck.notNull((Object)it, (String)"it");
        return it.searchForward((node, para, row) -> {
            if (para == null) {
                return false;
            }
            return this.isIntroRowFor(row, para, tableCell);
        });
    }

    protected boolean findTableCellBackward(TableCell tableCell, Iterator it) {
        NullCheck.notNull((Object)tableCell, (String)"tableCell");
        NullCheck.notNull((Object)it, (String)"it");
        return it.searchBackward((node, para, row) -> {
            if (para == null) {
                return false;
            }
            return this.isIntroRowFor(row, para, tableCell);
        });
    }

    protected TableCell isTableCellIntroRow(Iterator it) {
        NullCheck.notNull((Object)it, (String)"it");
        if (it.getIndexInParagraph() != 0) {
            return null;
        }
        for (Node node = it.getParagraph(); node != null; node = node.getParentNode()) {
            if (node instanceof TableCell) {
                return (TableCell)node;
            }
            if (node.getIndexInParentSubnodes() == 0) continue;
            return null;
        }
        return null;
    }

    protected boolean isIntroRowFor(Row row, Paragraph paragraph, Node nodeToCheck) {
        NullCheck.notNull((Object)row, (String)"row");
        NullCheck.notNull((Object)paragraph, (String)"paragraph");
        NullCheck.notNull((Object)nodeToCheck, (String)"nodeToCheck");
        if (row.getRelNum() != 0) {
            return false;
        }
        for (Node node = paragraph; node != null; node = node.getParentNode()) {
            if (node == nodeToCheck) {
                return true;
            }
            if (node.getIndexInParentSubnodes() == 0) continue;
            return false;
        }
        return false;
    }
}

