/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader;

import org.luwrain.controls.ControlContext;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.reader.view.Iterator;

class Jump {
    final Iterator it;
    final int pos;
    final String text;
    final Sounds sound;

    Jump() {
        this.it = null;
        this.pos = 0;
        this.text = "";
        this.sound = null;
    }

    Jump(Iterator it, int pos, String text, Sounds sound) {
        NullCheck.notNull((Object)it, (String)"it");
        NullCheck.notNull((Object)text, (String)"text");
        this.it = it;
        this.pos = pos;
        this.text = text;
        this.sound = sound;
    }

    boolean isEmpty() {
        return this.it == null;
    }

    void announce(ControlContext environment) {
        NullCheck.notNull((Object)environment, (String)"environment");
        if (this.isEmpty()) {
            environment.playSound(Sounds.BLOCKED);
            return;
        }
        if (this.sound != null) {
            environment.say(this.text, this.sound);
        } else {
            environment.say(this.text);
        }
    }

    static Jump nextSentence(Iterator fromIt, int fromPos) {
        NullCheck.notNull((Object)fromIt, (String)"fromIt");
        Iterator it = fromIt.clone();
        int pos = Jump.findNextSentenceBeginning(it.getText(), fromPos);
        if (pos >= 0) {
            if (pos < it.getText().length()) {
                return new Jump(it, pos, Jump.getSentenceText(it, pos), Jump.chooseSound(it, pos));
            }
            it = Jump.findTextBelow(it);
            return new Jump(it, 0, Jump.getSentenceText(it, 0), Jump.chooseSound(it, 0));
        }
        if (!it.moveNext()) {
            return new Jump();
        }
        do {
            Log.debug((String)"reader", (String)("checking " + it.getText()));
            if (it.isParagraphBeginning()) {
                return new Jump(it, 0, Jump.getSentenceText(it, 0), Jump.chooseSound(it, 0));
            }
            int pos2 = Jump.findNextSentenceBeginning(it.getText(), 0);
            if (pos2 < 0) continue;
            if (pos2 < it.getText().length()) {
                return new Jump(it, pos2, Jump.getSentenceText(it, pos2), Jump.chooseSound(it, pos));
            }
            it = Jump.findTextBelow(it);
            return new Jump(it, 0, Jump.getSentenceText(it, 0), Jump.chooseSound(it, 0));
        } while (it.moveNext());
        return new Jump();
    }

    private static Iterator findTextBelow(Iterator fromIt) {
        NullCheck.notNull((Object)fromIt, (String)"fromIt");
        Iterator it = fromIt;
        if (!it.moveNext()) {
            return fromIt;
        }
        do {
            if (it.getText().trim().isEmpty()) continue;
            return it;
        } while (it.moveNext());
        return fromIt;
    }

    private static int findNextSentenceBeginning(String text, int posFrom) {
        int pos;
        NullCheck.notNull((Object)text, (String)"text");
        for (pos = posFrom; pos < text.length() && text.charAt(pos) != '.' && text.charAt(pos) != '!' && text.charAt(pos) != '?'; ++pos) {
        }
        if (pos >= text.length()) {
            return -1;
        }
        while (pos < text.length() && (text.charAt(pos) == '.' || text.charAt(pos) == '!' || text.charAt(pos) == '?')) {
            ++pos;
        }
        if (pos >= text.length()) {
            return text.length();
        }
        while (pos < text.length() && Character.isSpace(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static String getSentenceText(Iterator fromIt, int fromPos) {
        NullCheck.notNull((Object)fromIt, (String)"fromIt");
        int pos = Jump.findNextSentenceBeginning(fromIt.getText(), fromPos);
        if (pos >= 0) {
            return fromIt.getText().substring(fromPos, pos);
        }
        StringBuilder b = new StringBuilder();
        b.append(fromIt.getText().substring(fromPos));
        Iterator it = fromIt.clone();
        if (!it.moveNext()) {
            return new String(b);
        }
        do {
            if (it.isParagraphBeginning()) {
                return new String(b);
            }
            int pos2 = Jump.findNextSentenceBeginning(it.getText(), 0);
            if (pos2 >= 0) {
                b.append(" " + it.getText().substring(0, pos2));
                return new String(b);
            }
            b.append(" " + it.getText());
        } while (it.moveNext());
        return new String(b);
    }

    private static Sounds chooseSound(Iterator it, int pos) {
        NullCheck.notNull((Object)it, (String)"it");
        if (!it.isParagraphBeginning() || pos > 0) {
            return null;
        }
        switch (it.getNode().getType()) {
            case LIST_ITEM: {
                return Sounds.LIST_ITEM;
            }
            case SECTION: {
                return Sounds.DOC_SECTION;
            }
        }
        return Sounds.PARAGRAPH;
    }
}

