/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.DocumentBuilder;
import org.luwrain.reader.DocumentBuilderFactory;
import org.luwrain.util.ClassUtils;

public final class DocumentBuilderLoader {
    private static final String LOG_COMPONENT = "reader";
    private static String PROP_PREFIX = "luwrain.ext.reader.doc.builder.";

    public DocumentBuilder newDocumentBuilder(Luwrain luwrain, String contentType) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notEmpty((Object)contentType, (String)"contentType");
        String propName = PROP_PREFIX + DocumentBuilderLoader.prepareContentType(contentType);
        String className = luwrain.getProperty(propName);
        if (className.isEmpty()) {
            Log.error((String)LOG_COMPONENT, (String)("no property '" + propName + "'"));
            return null;
        }
        Object obj = ClassUtils.newInstanceOf((ClassLoader)this.getClass().getClassLoader(), (String)className, DocumentBuilderFactory.class);
        if (obj == null) {
            return null;
        }
        return ((DocumentBuilderFactory)obj).newDocumentBuilder(luwrain);
    }

    private static String prepareContentType(String contentType) {
        NullCheck.notNull((Object)contentType, (String)"contentType");
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < contentType.length(); ++i) {
            char c = contentType.charAt(i);
            if (Character.isDigit(c)) {
                b.append("" + c);
                continue;
            }
            if (Character.isLetter(c)) {
                b.append("" + Character.toLowerCase(c));
                continue;
            }
            b.append("-");
        }
        return new String(b);
    }
}

