/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import java.util.Arrays;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.Run;

public class Paragraph
extends Node {
    protected Run[] runs = new Run[0];

    Paragraph() {
        super(Node.Type.PARAGRAPH);
    }

    Paragraph(Run[] runs) {
        super(Node.Type.PARAGRAPH);
        NullCheck.notNullItems((Object[])runs, (String)"runs");
        this.runs = (Run[])runs.clone();
    }

    public Run[] getRuns() {
        return this.runs != null ? (Run[])this.runs.clone() : new Run[]{};
    }

    public void setRuns(Run[] runs) {
        NullCheck.notNullItems((Object[])runs, (String)"runs");
        this.runs = (Run[])runs.clone();
    }

    @Override
    void preprocess() {
        this.subnodes = null;
        if (this.runs == null) {
            this.runs = new Run[0];
        }
        for (Run r : this.runs) {
            r.setParentNode(this);
            r.prepareText();
        }
    }

    @Override
    void setEmptyMark() {
        this.empty = true;
        if (this.importance < 0) {
            return;
        }
        if (this.runs == null || this.runs.length < 1) {
            return;
        }
        for (Run r : this.runs) {
            if (r.toString().trim().isEmpty()) continue;
            this.empty = false;
        }
    }

    @Override
    int prune() {
        if (this.runs == null) {
            return 0;
        }
        int k = 0;
        for (int i = 0; i < this.runs.length; ++i) {
            if (this.runs[i].isEmpty()) {
                ++k;
                continue;
            }
            this.runs[i - k] = this.runs[i];
        }
        if (k > 0) {
            this.runs = Arrays.copyOf(this.runs, this.runs.length - k);
        }
        return k;
    }

    int getParaIndex() {
        return this.getIndexInParentSubnodes();
    }

    @Override
    public String toString() {
        if (this.runs == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Run r : this.runs) {
            sb.append(r.toString());
        }
        return sb.toString();
    }

    @Override
    public String getCompleteText() {
        if (this.runs == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Run r : this.runs) {
            String value = r.text();
            if (value.isEmpty()) continue;
            if (!first) {
                b.append(" ");
            }
            first = false;
            b.append(value);
        }
        return new String(b);
    }
}

