/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.fetching;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.PimException;
import org.luwrain.pim.fetching.FetchingException;

public final class MailConnections {
    private static final String LOG_COMPONENT = "pim";
    static final int LIMIT_MESSAGES_LOAD = 500;
    private final Properties props;
    private final Session session;
    private final Store store;
    private final Transport smtpTransport;

    public MailConnections(final Params params, boolean pop3) throws PimException {
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notEmpty((Object)params.host, (String)"params.host");
        NullCheck.notNull((Object)params.login, (String)"params.login");
        NullCheck.notNull((Object)params.passwd, (String)"params.passwd");
        this.props = new Properties();
        if (pop3) {
            this.props.put("mail.store.protocol", "pop3");
            this.props.put("mail.pop3.auth", new Boolean(params.doAuth).toString());
            this.props.put("mail.pop3.host", params.host);
            this.props.put("mail.pop3.user", params.login);
            this.props.put("mail.pop3.password", params.passwd);
            this.props.put("mail.pop3.port", String.valueOf(params.port));
            this.props.put("mail.pop3.ssl.enable", new Boolean(params.ssl).toString());
            this.props.put("mail.pop3.starttls.enable", new Boolean(params.tls).toString());
            for (Map.Entry<String, String> p : params.extProps.entrySet()) {
                this.props.put(p.getKey(), p.getValue());
            }
            try {
                this.session = Session.getInstance((Properties)this.props, null);
                this.store = this.session.getStore();
                this.store.connect(params.host, params.port, params.login, params.passwd);
                Log.debug((String)LOG_COMPONENT, (String)("connected to " + params.host));
            }
            catch (Throwable e) {
                Log.error((String)LOG_COMPONENT, (String)("connecting to " + params.host + ":" + params.port + ": " + e.getClass().getName() + ":" + e.getMessage()));
                throw new PimException(e);
            }
            this.smtpTransport = null;
        } else {
            this.props.put("mail.smtp.auth", new Boolean(params.doAuth));
            this.props.put("mail.smtp.host", params.host);
            this.props.put("mail.smtp.port", new Integer(params.port).toString());
            this.props.put("mail.smtp.ssl.enable", new Boolean(params.ssl).toString());
            this.props.put("mail.smtp.starttls.enable", new Boolean(params.tls).toString());
            try {
                this.session = Session.getInstance((Properties)this.props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(params.login, params.passwd);
                    }
                });
                this.smtpTransport = this.session.getTransport("smtp");
                this.smtpTransport.connect();
            }
            catch (MessagingException e) {
                throw new PimException(e);
            }
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fetchPop3(String folderName, Listener listener, boolean deleteMessagesOnServer) throws IOException, InterruptedException {
        NullCheck.notEmpty((Object)folderName, (String)"folderName");
        NullCheck.notNull((Object)listener, (String)"listener");
        try {
            Folder folder = null;
            try {
                Message[] messages;
                folder = this.store.getFolder(folderName);
                folder.open(2);
                int msgCount = folder.getMessageCount();
                if (msgCount == 0) {
                    listener.numberOfNewMessages(0, false);
                    boolean bl = true;
                    return bl;
                }
                if (msgCount > 500) {
                    listener.numberOfNewMessages(500, true);
                    messages = folder.getMessages(1, 500);
                } else {
                    listener.numberOfNewMessages(msgCount, false);
                    messages = folder.getMessages(1, msgCount);
                }
                for (int i = 0; i < messages.length; ++i) {
                    Thread.currentThread();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (!listener.saveMessage(this.saveToByteArray(messages[i]), i, messages.length)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!deleteMessagesOnServer) continue;
                    messages[i].setFlag(Flags.Flag.DELETED, true);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (folder != null) {
                    folder.close(true);
                }
            }
        }
        catch (MessagingException e) {
            throw new IOException("Unable to fetch messages from the server", e);
        }
    }

    public void send(byte[] bytes) throws FetchingException {
        NullCheck.notNull((Object)this.smtpTransport, (String)"smtpTransport");
        try {
            Message message = this.loadFromByteArray(bytes);
            this.smtpTransport.sendMessage(message, message.getRecipients(MimeMessage.RecipientType.TO));
        }
        catch (IOException | MessagingException e) {
            throw new FetchingException((Exception)e);
        }
    }

    public String[] getFolderNames() throws Exception {
        Folder[] folders = this.store.getDefaultFolder().list();
        String[] result = new String[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            result[i] = folders[i].getFullName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] saveToByteArray(Message message) throws MessagingException, IOException {
        NullCheck.notNull((Object)message, (String)"message");
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            message.writeTo((OutputStream)byteStream);
            byteStream.flush();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message loadFromByteArray(byte[] bytes) throws MessagingException, IOException {
        NullCheck.notNull((Object)bytes, (String)"bytes");
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            MimeMessage mimeMessage = new MimeMessage(this.session, (InputStream)is);
            return mimeMessage;
        }
    }

    public static final class Params {
        public boolean doAuth = false;
        public String host = "";
        public int port = 25;
        public String login;
        public String passwd;
        public boolean ssl = false;
        public boolean tls = false;
        public Map<String, String> extProps = new HashMap<String, String>();
    }

    public static interface Listener {
        public void numberOfNewMessages(int var1, boolean var2);

        public boolean saveMessage(byte[] var1, int var2, int var3);
    }
}

