/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.pim.mail.MessageContentItem;

final class MimePartsExtractor {
    private static final Logger log = LogManager.getLogger();
    final List<MessageContentItem> items = new ArrayList<MessageContentItem>();

    MimePartsExtractor() {
    }

    void on(MimePart p) throws IOException, MessagingException {
        this.on(p, false);
    }

    void on(MimePart p, boolean alternative) throws IOException, MessagingException {
        if (p == null || p.getContent() == null) {
            return;
        }
        String contentType = p.getContentType() != null ? MimeUtility.decodeText((String)p.getContentType()) : "";
        String fileName = p.getFileName() != null ? MimeUtility.decodeText((String)p.getFileName()) : null;
        String disposition = p.getDisposition();
        Object object = p.getContent();
        if (object instanceof MimeMultipart) {
            MimeMultipart mm = (MimeMultipart)object;
            for (int i = 0; i < mm.getCount(); ++i) {
                this.on((MimePart)((MimeBodyPart)mm.getBodyPart(i)), alternative || contentType.toLowerCase().startsWith("multipart/alternative"));
            }
            return;
        }
        MessageContentItem item = new MessageContentItem();
        item.setContentType(contentType);
        item.setDisposition(disposition);
        item.setFileName(fileName);
        item.setAlternative(alternative);
        Object object2 = p.getContent();
        if (object2 instanceof String) {
            String s = (String)object2;
            item.setText(s);
        }
        this.items.add(item);
    }

    private void handle(MimeMultipart mm) throws IOException, MessagingException {
        for (int i = 0; i < mm.getCount(); ++i) {
            MimeBodyPart p = (MimeBodyPart)mm.getBodyPart(i);
            if (p == null) continue;
            this.on((MimePart)p);
        }
    }
}

