/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news;

import java.util.ArrayList;
import java.util.Properties;
import org.luwrain.core.NullCheck;
import org.luwrain.pim.news.MediaResource;

public final class MediaResources {
    private Properties props;

    public MediaResources(Properties props) {
        NullCheck.notNull((Object)props, (String)"props");
        this.props = props;
    }

    public void save(MediaResource[] resources) {
        NullCheck.notNullItems((Object[])resources, (String)"resources");
        this.props.setProperty("media.count", "" + resources.length);
        for (int i = 0; i < resources.length; ++i) {
            this.props.setProperty("media." + i + ".url", resources[i].getUrl());
        }
    }

    public MediaResource[] load() {
        int count;
        String countStr = this.props.getProperty("media.count");
        if (countStr == null || countStr.isEmpty()) {
            return new MediaResource[0];
        }
        try {
            count = Integer.parseInt(countStr);
        }
        catch (NumberFormatException e) {
            return new MediaResource[0];
        }
        ArrayList<MediaResource> res = new ArrayList<MediaResource>();
        for (int i = 0; i < count; ++i) {
            String url = this.props.getProperty("media." + i + ".url");
            if (url == null) {
                return new MediaResource[0];
            }
            MediaResource resource = new MediaResource();
            resource.setUrl(url);
            res.add(resource);
        }
        return res.toArray(new MediaResource[res.size()]);
    }
}

