/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.news.nitrite;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.pim.ExecQueues;
import org.luwrain.pim.news.NewsArticles;
import org.luwrain.pim.news.NewsGroups;
import org.luwrain.pim.news.NewsStoring;
import org.luwrain.pim.news.nitrite.Article;
import org.luwrain.pim.news.nitrite.Articles;
import org.luwrain.pim.news.nitrite.Groups;
import org.luwrain.pim.storage.NitriteStorage;

public final class Storing
implements NewsStoring {
    private final Registry registry;
    final NitriteStorage<Article> storage;
    private final ExecQueues execQueues;
    private final boolean highPriority;
    private final Articles articles;
    private final Groups groups;

    public Storing(Registry registry, NitriteStorage<Article> storage, ExecQueues execQueues, boolean highPriority) {
        NullCheck.notNull((Object)registry, (String)"registry");
        NullCheck.notNull(storage, (String)"storage");
        NullCheck.notNull((Object)execQueues, (String)"execQueues");
        this.registry = registry;
        this.storage = storage;
        this.execQueues = execQueues;
        this.highPriority = highPriority;
        this.articles = new Articles(this);
        this.groups = new Groups(registry);
    }

    @Override
    public NewsArticles getArticles() {
        return this.articles;
    }

    @Override
    public NewsGroups getGroups() {
        return this.groups;
    }

    <T> T execInQueue(Callable<T> callable) throws Exception {
        NullCheck.notNull(callable, (String)"callable");
        return this.execQueues.exec(new FutureTask<T>(callable), this.highPriority);
    }
}

