/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.workers;

import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Worker;
import org.luwrain.pim.fetching.Control;
import org.luwrain.pim.fetching.Strings;
import org.luwrain.pim.workers.DefaultControl;

public class News
implements Worker {
    public static String NAME = "luwrain.pim.fetch.news";
    protected static final String LOG_COMPONENT = "pim-workers";
    protected final Luwrain luwrain;
    protected final Control control;

    public News(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.control = new DefaultControl(luwrain);
    }

    public News(Control control) {
        NullCheck.notNull((Object)control, (String)"control");
        this.control = control;
        this.luwrain = control.luwrain();
    }

    public void run() {
        Strings strings = (Strings)this.luwrain.i18n().getStrings("luwrain.fetching");
        if (strings == null) {
            Log.error((String)LOG_COMPONENT, (String)("unable to launch the worker '" + NAME + "' since there is no strings object with the name 'luwrain.fetching'"));
            return;
        }
        try {
            org.luwrain.pim.fetching.News newsFetching = new org.luwrain.pim.fetching.News(this.control, strings);
            newsFetching.fetch();
        }
        catch (InterruptedException e) {
            Log.debug((String)LOG_COMPONENT, (String)("the worker '" + NAME + "' has been interrupted"));
            return;
        }
        catch (Throwable e) {
            Log.error((String)LOG_COMPONENT, (String)("the worker '" + NAME + "' failed:" + e.getClass().getName() + ":" + e.getMessage()));
            return;
        }
    }

    public String getExtObjName() {
        return NAME;
    }

    public int getFirstLaunchDelay() {
        return 0;
    }

    public int getLaunchPeriod() {
        return 0;
    }
}

