/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.pim.workers;

import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Worker;
import org.luwrain.pim.Hooks;
import org.luwrain.pim.mail.Message;
import org.luwrain.pim.mail.MessageDecoder;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.mail.persistence.dao.AccountDAO;
import org.luwrain.pim.mail.persistence.model.Account;

public class Pop3
implements Worker {
    protected static final Logger log = LogManager.getLogger();
    public static String NAME = "luwrain.pim.fetch.pop3";
    protected final Luwrain luwrain;

    public Pop3(Luwrain luwrain) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
    }

    public void run() {
        try {
            MailPersistence persist = (MailPersistence)this.luwrain.createInstance(MailPersistence.class);
            AccountDAO accountDAO = persist.getAccountDAO();
            List<Account> accounts = accountDAO.getAll();
            log.debug("fetching POP3 mail from " + accounts.size() + " accounts");
            for (Account a : accounts) {
                MessageDecoder decoder = new MessageDecoder();
                org.luwrain.pim.mail.proto.Pop3 pop3 = new org.luwrain.pim.mail.proto.Pop3(a);
                pop3.getMessages((message, extData) -> {
                    decoder.onMessage((Message)message);
                    Hooks.mailIncoming(this.luwrain, message);
                });
            }
        }
        catch (Throwable e) {
            log.error(NAME, e);
        }
    }

    public String getExtObjName() {
        return NAME;
    }

    public int getFirstLaunchDelay() {
        return 0;
    }

    public int getLaunchPeriod() {
        return 0;
    }
}

