/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings.mail.accounts;

import java.util.ArrayList;
import java.util.List;
import org.luwrain.core.Event;
import org.luwrain.core.Luwrain;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.Element;
import org.luwrain.pim.mail.persistence.MailPersistence;
import org.luwrain.pim.mail.persistence.model.Account;
import org.luwrain.settings.mail.Strings;
import org.luwrain.settings.mail.accounts.AccountElement;
import org.luwrain.settings.mail.accounts.Conv;

public final class Accounts {
    final Luwrain luwrain;
    final Strings strings;
    final Conv conv;

    public Accounts(Luwrain luwrain, Strings strings) {
        this.luwrain = luwrain;
        this.strings = strings;
        this.conv = new Conv(this);
    }

    public Element[] getAccountsElements(Element parent) {
        List<Account> accounts = ((MailPersistence)this.luwrain.createInstance(MailPersistence.class)).getAccountDAO().getAll();
        ArrayList<AccountElement> res = new ArrayList<AccountElement>();
        for (Account a : accounts) {
            res.add(new AccountElement(parent, a.getId(), a.getName()));
        }
        return res.toArray(new Element[res.size()]);
    }

    boolean onActionEvent(ControlPanel controlPanel, ActionEvent event, int id) {
        if (ActionEvent.isAction((Event)event, (String)"add-mail-account")) {
            return this.onAddAccount(controlPanel);
        }
        if (ActionEvent.isAction((Event)event, (String)"delete-mail-account")) {
            return this.onDeleteAccount(controlPanel, id);
        }
        return false;
    }

    private boolean onAddAccount(ControlPanel controlPanel) {
        Account.Type type = this.conv.newAccountType();
        if (type == null) {
            return true;
        }
        String title = this.conv.newAccountTitle();
        if (title == null) {
            return true;
        }
        Account account = new Account();
        account.setType(type);
        account.setName(title);
        switch (type) {
            case SMTP: {
                account.setPort(587);
                account.setTls(true);
                break;
            }
            case POP3: {
                account.setPort(995);
                account.setSsl(true);
            }
        }
        ((MailPersistence)this.luwrain.createInstance(MailPersistence.class)).getAccountDAO().add(account);
        controlPanel.refreshSectionsTree();
        return true;
    }

    private boolean onDeleteAccount(ControlPanel controlPanel, int id) {
        if (id < 0) {
            return false;
        }
        MailPersistence persist = (MailPersistence)this.luwrain.createInstance(MailPersistence.class);
        Account account = persist.getAccountDAO().getById(id);
        if (account == null) {
            return false;
        }
        if (this.conv.confirmAccountDeleting(account.getName())) {
            persist.getAccountDAO().delete(account);
            controlPanel.refreshSectionsTree();
        }
        return true;
    }
}

