/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.ru;

import java.util.Date;
import java.util.Map;
import org.luwrain.core.HookContainer;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.ScriptFile;
import org.luwrain.core.ScriptSource;
import org.luwrain.i18n.LangBase;
import org.luwrain.i18n.ru.DateUtils;
import org.luwrain.i18n.ru.SpeakableText;
import org.luwrain.i18n.ru.WordList;
import org.luwrain.nlp.Word;
import org.luwrain.script.core.ScriptCore;

final class Lang
extends LangBase {
    static final String LOG_COMPONENT = "ru";
    private final ScriptCore scriptCore;
    private final SpeakableText speakableText;
    private final WordList wordsList = new WordList();

    Lang(Luwrain luwrain, Map<String, String> staticStrings, Map<String, String> chars) {
        super(LOG_COMPONENT, luwrain, staticStrings, chars);
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.scriptCore = new ScriptCore(luwrain);
        Log.debug((String)LOG_COMPONENT, (String)"Loading Russian");
        for (ScriptFile s : luwrain.getScriptFilesList(LOG_COMPONENT)) {
            try {
                this.scriptCore.load((ScriptSource)s);
            }
            catch (Throwable e) {
                Log.error((String)LOG_COMPONENT, (String)("unable to load " + s.toString() + ": " + e.getClass().getName() + ": " + e.getMessage()));
            }
        }
        this.speakableText = new SpeakableText((HookContainer)this.scriptCore);
        this.wordsList.loadFromResource();
    }

    public String pastTimeBrief(Date date) {
        return new DateUtils().passedTimeBrief(date) + " \u043d\u0430\u0437\u0430\u0434";
    }

    public String getNumberStr(int count, String entities) {
        NullCheck.notNull((Object)entities, (String)"entities");
        switch (entities) {
            case "items": {
                return count + " " + Lang.afterNum(count, "\u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432", "\u044d\u043b\u0435\u043c\u0435\u043d\u0442", "\u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430");
            }
            case "percents": {
                return count + " " + Lang.afterNum(count, "\u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432", "\u043f\u0440\u043e\u0446\u0435\u043d\u0442", "\u043f\u0440\u043e\u0446\u0435\u043d\u0442\u0430");
            }
            case "hours": {
                return count + " " + Lang.afterNum(count, "\u0447\u0430\u0441\u043e\u0432", "\u0447\u0430\u0441", "\u0447\u0430\u0441\u0430");
            }
            case "minutes": {
                return count + " " + Lang.afterNum(count, "\u043c\u0438\u043d\u0443\u0442", "\u043c\u0438\u043d\u0443\u0442\u0430", "\u043c\u0438\u043d\u0443\u0442\u044b");
            }
        }
        return "#\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0435\u0439 '" + entities + "'#";
    }

    public String getSpeakableText(String text, Luwrain.SpeakableTextType type) {
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull((Object)type, (String)"type");
        return this.speakableText.process(text, type);
    }

    public Word[] getWord(String word) {
        NullCheck.notEmpty((Object)word, (String)"word");
        return this.wordsList.findWord(word);
    }

    static String afterNum(int num, String afterZero, String afterOne, String afterTwo) {
        if (num < 0) {
            throw new IllegalArgumentException("num may not be negative");
        }
        if (num == 0 || num % 10 == 0) {
            return afterZero;
        }
        if (num % 100 >= 11 && num % 100 <= 19) {
            return afterZero;
        }
        if (num % 10 == 1) {
            return afterOne;
        }
        if (num % 10 >= 2 && num % 10 <= 4) {
            return afterTwo;
        }
        return afterZero;
    }

    private String bytesNum(long num) {
        if (num > 0x40000000L) {
            long g = num / 0x40000000L;
            long rest = num - g * 1024L * 1024L * 1024L;
            return g + "," + (rest /= 0x6600000L) + "\u0413\u0411";
        }
        if (num > 0x100000L) {
            long m = num / 0x100000L;
            long rest = num - m * 1024L * 1024L;
            return m + "," + (rest /= 104448L) + "\u041c\u0411";
        }
        if (num > 1024L) {
            long k = num / 1024L;
            long rest = num - k * 1024L;
            return k + "," + (rest /= 102L) + "\u041a\u0411";
        }
        return num + "\u0411";
    }
}

