/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.calc;

import java.util.Arrays;
import java.util.LinkedList;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.calc.App;
import org.luwrain.app.calc.Strings;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public final class MainLayout
extends LayoutBase {
    private static final String LOG_COMPONENT = "calc";
    private final App app;
    private final EditArea editArea;

    MainLayout(final App app) {
        super(app);
        this.app = app;
        EditArea.Params params = new EditArea.Params();
        params.context = this.getControlContext();
        params.name = ((Strings)app.getStrings()).appName();
        params.appearance = new DefaultEditAreaAppearance(this.getControlContext()){

            @Override
            public void announceLine(int index, String line) {
                NavigationArea.defaultLineAnnouncement(this.context, index, MainLayout.this.getLuwrain().getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING));
            }
        };
        params.editFactory = p -> {
            p.model = MainLayout.createBlockingModel(p.model);
            return new MultilineEdit(p);
        };
        params.changeListeners = Arrays.asList((area, lines, hotPoint) -> this.hotUpdate());
        this.editArea = new EditArea(params){

            @Override
            public boolean onInputEvent(InputEvent event) {
                if (!event.isSpecial()) {
                    switch (event.getChar()) {
                        case '\"': 
                        case '\'': 
                        case ';': {
                            return false;
                        }
                        case '=': {
                            return this.onSystemEvent(new SystemEvent(SystemEvent.Code.OK));
                        }
                    }
                    if (this.getContent().getLineCount() == 4 && this.getContent().getLine(0).equals("0") && this.getHotPointX() == 0 && this.getHotPointY() == 0) {
                        this.getContent().setLine(0, "");
                    }
                    return super.onInputEvent(event);
                }
                return super.onInputEvent(event);
            }

            @Override
            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() != SystemEvent.Type.REGULAR) {
                    return super.onSystemEvent(event);
                }
                switch (event.getCode()) {
                    case CLEAR: {
                        this.setText(new String[]{"0", "", "# 0", ""});
                        this.setHotPoint(0, 0);
                        return true;
                    }
                    case OK: {
                        try {
                            Number res = app.calculate(MainLayout.this.getLinesToEval());
                            if (res != null) {
                                app.message(MainLayout.this.getLuwrain().getSpeakableText(MainLayout.this.formatNum(res), Luwrain.SpeakableTextType.PROGRAMMING), Luwrain.MessageType.OK);
                            } else {
                                app.message("0", Luwrain.MessageType.OK);
                            }
                            return true;
                        }
                        catch (Exception e) {
                            Log.debug(MainLayout.LOG_COMPONENT, "calculation faild: " + e.getClass().getName() + ": " + e.getMessage());
                            e.printStackTrace();
                            MainLayout.this.getLuwrain().playSound(Sounds.ERROR);
                            return true;
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.editArea.getContent().setLines(new String[]{"0", "", "# 0", ""});
        this.setAreaLayout(this.editArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    private void hotUpdate() {
        try {
            Number res = this.app.calculate(this.getLinesToEval());
            if (res != null) {
                this.putResLine("# " + this.formatNum(res));
            } else {
                this.putResLine("# 0");
            }
        }
        catch (Throwable e) {
            this.putResLine("# " + ((Strings)this.app.getStrings()).error());
        }
    }

    private void putResLine(String text) {
        this.editArea.update((lines, hotPoint) -> {
            lines.setLine(lines.getLineCount() - 2, text);
            return false;
        });
    }

    private String[] getLinesToEval() {
        String[] lines = this.editArea.getText();
        LinkedList<String> res = new LinkedList<String>();
        for (int i = 0; i < lines.length - 3; ++i) {
            res.add(lines[i]);
        }
        return res.toArray(new String[res.size()]);
    }

    private String formatNum(Number num) {
        if (num instanceof Integer || num instanceof Long) {
            return "" + num.intValue();
        }
        return String.format("%.5f", Float.valueOf(num.floatValue()));
    }

    private static MultilineEdit.Model createBlockingModel(final MultilineEdit.Model origModel) {
        return new MultilineEdit.Model(){

            @Override
            public int getLineCount() {
                return origModel.getLineCount();
            }

            @Override
            public String getLine(int index) {
                return origModel.getLine(index);
            }

            @Override
            public int getHotPointX() {
                return origModel.getHotPointX();
            }

            @Override
            public int getHotPointY() {
                return origModel.getHotPointY();
            }

            @Override
            public String getTabSeq() {
                return origModel.getTabSeq();
            }

            @Override
            public MultilineEdit.ModificationResult deleteChar(int pos, int lineIndex) {
                if (lineIndex >= this.getLineCount() - 3) {
                    return new MultilineEdit.ModificationResult(false);
                }
                return origModel.deleteChar(pos, lineIndex);
            }

            @Override
            public MultilineEdit.ModificationResult deleteRegion(int fromX, int fromY, int toX, int toY) {
                int x;
                int y;
                if (fromY < toY) {
                    y = toY;
                    x = toX;
                } else if (fromY > toY) {
                    y = fromY;
                    x = fromX;
                } else {
                    y = fromY;
                    x = Math.max(fromX, toX);
                }
                int count = this.getLineCount();
                if (y >= count - 2) {
                    return new MultilineEdit.ModificationResult(false);
                }
                if (y == count - 3 && x > 0) {
                    return new MultilineEdit.ModificationResult(false);
                }
                if (count - Math.abs(toY - fromY) < 4) {
                    return new MultilineEdit.ModificationResult(false);
                }
                return origModel.deleteRegion(fromX, fromY, toX, toY);
            }

            @Override
            public MultilineEdit.ModificationResult insertRegion(int x, int y, String[] lines) {
                NullCheck.notNullItems((Object[])lines, (String)"lines");
                if (y >= this.getLineCount() - 3) {
                    return new MultilineEdit.ModificationResult(false);
                }
                for (String s : lines) {
                    if (s.indexOf(";") >= 0) {
                        return new MultilineEdit.ModificationResult(false);
                    }
                    if (s.indexOf("=") >= 0) {
                        return new MultilineEdit.ModificationResult(false);
                    }
                    if (s.indexOf("'") >= 0) {
                        return new MultilineEdit.ModificationResult(false);
                    }
                    if (s.indexOf("\"") < 0) continue;
                    return new MultilineEdit.ModificationResult(false);
                }
                return origModel.insertRegion(x, y, lines);
            }

            @Override
            public MultilineEdit.ModificationResult putChars(int pos, int lineIndex, String str) {
                if (lineIndex >= this.getLineCount() - 3) {
                    return new MultilineEdit.ModificationResult(false);
                }
                return origModel.putChars(pos, lineIndex, str);
            }

            @Override
            public MultilineEdit.ModificationResult mergeLines(int firstLineIndex) {
                int count = this.getLineCount();
                if (count <= 4) {
                    return new MultilineEdit.ModificationResult(false);
                }
                if (firstLineIndex >= count - 3) {
                    return new MultilineEdit.ModificationResult(false);
                }
                if (firstLineIndex == count - 4 && !this.getLine(firstLineIndex).isEmpty()) {
                    return new MultilineEdit.ModificationResult(false);
                }
                return origModel.mergeLines(firstLineIndex);
            }

            @Override
            public MultilineEdit.ModificationResult splitLine(int pos, int lineIndex) {
                if (lineIndex >= this.getLineCount() - 3) {
                    return new MultilineEdit.ModificationResult(false);
                }
                return origModel.splitLine(pos, lineIndex);
            }
        };
    }
}

