/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.Calendar;
import java.util.Locale;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class CalendarArea
implements Area {
    private ControlContext environment;
    private Calendar calendar;
    private int[][] table;
    private int tableX = 0;
    private int tableY = 0;

    public CalendarArea(ControlContext environment, Calendar calendar) {
        this.environment = environment;
        this.calendar = calendar;
        this.refresh();
    }

    @Override
    public int getHotPointX() {
        return this.tableX * 4;
    }

    @Override
    public int getHotPointY() {
        return this.tableY + 1;
    }

    @Override
    public int getLineCount() {
        return 1 + (this.table != null ? this.table.length : 0);
    }

    @Override
    public String getLine(int index) {
        if (index == 0) {
            return "Mon Tue Wen Thu Fri Sat Sun";
        }
        if (this.table == null || index - 1 >= this.table.length) {
            return "";
        }
        return this.constructLine(index - 1);
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        if (!event.isSpecial() || event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case ARROW_RIGHT: {
                this.calendar.add(5, 1);
                break;
            }
            case ARROW_LEFT: {
                this.calendar.add(5, -1);
                break;
            }
            case ARROW_DOWN: {
                this.calendar.add(4, 1);
                break;
            }
            case ARROW_UP: {
                this.calendar.add(4, -1);
                break;
            }
            case PAGE_DOWN: {
                this.calendar.add(2, 1);
                break;
            }
            case PAGE_UP: {
                this.calendar.add(2, -1);
                break;
            }
            default: {
                return false;
            }
        }
        this.refresh();
        this.environment.onAreaNewContent(this);
        this.environment.onAreaNewHotPoint(this);
        this.environment.onAreaNewName(this);
        this.environment.say(this.constructDayStringForSpeech(this.calendar));
        return true;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        return false;
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        return false;
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public String getAreaName() {
        return this.calendar.getDisplayName(2, 2, Locale.ROOT) + ", " + this.calendar.get(1);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.refresh();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String constructDayStringForSpeech(Calendar c) {
        return c.getDisplayName(7, 2, Locale.ROOT) + " " + c.getDisplayName(2, 2, Locale.ROOT) + " " + c.get(5) + " " + c.get(1);
    }

    private void refresh() {
        this.table = this.fillTable();
        this.tableX = 0;
        this.tableY = 0;
        if (this.table == null) {
            return;
        }
        int day = this.calendar.get(5);
        for (int i = 0; i < this.table.length; ++i) {
            for (int j = 0; j < this.table[i].length; ++j) {
                if (this.table[i][j] != day) continue;
                this.tableY = i;
                this.tableX = j;
            }
        }
    }

    private int[][] fillTable() {
        int i;
        Calendar c = (Calendar)this.calendar.clone();
        int[][] res = new int[c.getActualMaximum(4)][];
        for (i = 0; i < res.length; ++i) {
            res[i] = new int[7];
        }
        for (i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = -1;
            }
        }
        int count = c.getActualMaximum(5);
        int i2 = 1;
        while (i2 <= count) {
            c.set(5, i2);
            int week = c.get(4);
            int dayOfWeek = c.get(7) > 1 ? c.get(7) - 1 : 7;
            res[week - 1][dayOfWeek - 1] = i2++;
        }
        return res;
    }

    private String constructLine(int index) {
        if (this.table == null || index >= this.table.length) {
            return "";
        }
        Object line = "";
        for (int i = 0; i < this.table[index].length; ++i) {
            if (this.table[index][i] >= 0) {
                if (this.table[index][i] < 10) {
                    line = (String)line + this.table[index][i] + "   ";
                    continue;
                }
                line = (String)line + this.table[index][i] + "  ";
                continue;
            }
            line = (String)line + "    ";
        }
        return line;
    }
}

