/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.SystemEvent;

public class RegionPoint
implements AbstractRegionPoint {
    protected int hotPointX = -1;
    protected int hotPointY = -1;

    @Override
    public boolean onSystemEvent(SystemEvent event, int hotPointX, int hotPointY) {
        NullCheck.notNull((Object)event, (String)"event");
        if (hotPointX < 0 || hotPointY < 0) {
            throw new IllegalArgumentException("hotPointX and hotPointY must be greater or equal to zero");
        }
        if (event.getType() == SystemEvent.Type.REGULAR) {
            switch (event.getCode()) {
                case REGION_POINT: {
                    this.hotPointX = hotPointX;
                    this.hotPointY = hotPointY;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isInitialized() {
        return this.hotPointX >= 0 && this.hotPointY >= 0;
    }

    @Override
    public void set(int hotPointX, int hotPointY) {
        if (hotPointX < 0 || hotPointY < 0) {
            throw new IllegalArgumentException("hotPointX and hotPointY must be greater or equal to zero");
        }
        this.hotPointX = hotPointX;
        this.hotPointY = hotPointY;
    }

    @Override
    public int getHotPointX() {
        return this.hotPointX;
    }

    @Override
    public int getHotPointY() {
        return this.hotPointY;
    }

    @Override
    public void reset() {
        this.hotPointX = -1;
        this.hotPointY = -1;
    }
}

