/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.RegionTextQueryTranslator;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.util.TextUtils;

public class SingleLineEdit
implements ClipboardTranslator.Provider,
RegionTextQueryTranslator.Provider {
    protected final ControlContext context;
    protected final Model model;
    protected final AbstractRegionPoint regionPoint;
    protected final RegionTextQueryTranslator regionTextQueryTranslator;
    protected final ClipboardTranslator clipboardTranslator;

    public SingleLineEdit(ControlContext context, Model model, AbstractRegionPoint regionPoint) {
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(model, "model can't be null");
        Objects.requireNonNull(regionPoint, "regionPoint can't be null");
        this.context = context;
        this.model = model;
        this.regionPoint = regionPoint;
        this.clipboardTranslator = new ClipboardTranslator(this, regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
        this.regionTextQueryTranslator = new RegionTextQueryTranslator(this, regionPoint, EnumSet.noneOf(RegionTextQueryTranslator.Flags.class));
    }

    public SingleLineEdit(Params params) {
        Objects.requireNonNull(params.context, "params.context can't be null");
        Objects.requireNonNull(params.model, "params.model can't be null");
        Objects.requireNonNull(params.regionPoint, "params.regionPoint can't be null");
        this.context = params.context;
        this.model = params.model;
        this.regionPoint = params.regionPoint;
        this.clipboardTranslator = new ClipboardTranslator(this, this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
        this.regionTextQueryTranslator = new RegionTextQueryTranslator(this, this.regionPoint, EnumSet.noneOf(RegionTextQueryTranslator.Flags.class));
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.withControl() || event.withAlt()) {
            return false;
        }
        if (event.isSpecial()) {
            switch (event.getSpecial()) {
                case HOME: {
                    return this.onHome(event);
                }
                case BACKSPACE: {
                    return this.onBackspace(event);
                }
                case DELETE: {
                    return this.onDelete(event);
                }
                case TAB: {
                    return this.onTab(event);
                }
            }
            return false;
        }
        return this.onCharacter(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case CLIPBOARD_PASTE: {
                return this.onClipboardPaste();
            }
            case CLEAR: {
                return this.onClear();
            }
        }
        if (this.clipboardTranslator.onSystemEvent(event, this.model.getHotPointX(), 0)) {
            return true;
        }
        return this.regionTextQueryTranslator.onSystemEvent(event, this.model.getHotPointX(), 0);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        return this.regionTextQueryTranslator.onAreaQuery(query, this.model.getHotPointX(), 0);
    }

    protected boolean onHome(InputEvent event) {
        String line = this.model.getLine();
        NullCheck.notNull((Object)line, (String)"line");
        this.model.setHotPointX(0);
        if (!line.isEmpty()) {
            this.context.sayLetter(line.charAt(0));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
        }
        return true;
    }

    protected boolean onBackspace(InputEvent event) {
        String line = this.model.getLine();
        NullCheck.notNull((Object)line, (String)"line");
        int pos = this.model.getHotPointX();
        if (pos < 0 || pos > line.length()) {
            return false;
        }
        if (pos < 1) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_TEXT));
            return true;
        }
        String newLine = new String(line.substring(0, pos - 1) + line.substring(pos));
        this.model.setLine(newLine);
        this.model.setHotPointX(pos - 1);
        this.context.sayLetter(line.charAt(pos - 1));
        return true;
    }

    protected boolean onDelete(InputEvent event) {
        String line = this.model.getLine();
        if (line == null) {
            return false;
        }
        int pos = this.model.getHotPointX();
        if (pos < 0 || pos > line.length()) {
            return false;
        }
        if (pos >= line.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_TEXT));
            return true;
        }
        if (pos == line.length() - 1) {
            this.model.setLine(line.substring(0, pos));
            this.context.sayLetter(line.charAt(pos));
            return true;
        }
        String newLine = new String(line.substring(0, pos) + line.substring(pos + 1));
        this.model.setLine(newLine);
        this.context.sayLetter(line.charAt(pos));
        return true;
    }

    protected boolean onTab(InputEvent event) {
        String line = this.model.getLine();
        if (line == null) {
            return false;
        }
        int pos = this.model.getHotPointX();
        if (pos < 0 || pos > line.length()) {
            return false;
        }
        String tabSeq = this.model.getTabSeq();
        if (tabSeq == null) {
            return false;
        }
        if (pos < line.length()) {
            String newLine = new String(line.substring(0, pos) + tabSeq + line.substring(pos));
            this.model.setLine(newLine);
        } else {
            this.model.setLine(line + tabSeq);
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.TAB));
        this.model.setHotPointX(pos + tabSeq.length());
        return true;
    }

    protected boolean onCharacter(InputEvent event) {
        String line = this.model.getLine();
        if (line == null) {
            return false;
        }
        int pos = this.model.getHotPointX();
        if (pos < 0 || pos > line.length()) {
            return false;
        }
        if (pos == line.length()) {
            this.model.setLine(line + event.getChar());
            this.model.setHotPointX(pos + 1);
            if (event.getChar() == ' ') {
                String lastWord = TextUtils.getLastWord(line, line.length());
                if (lastWord != null && !lastWord.isEmpty()) {
                    this.context.say(lastWord);
                } else {
                    this.context.setEventResponse(DefaultEventResponse.hint(Hint.SPACE));
                }
            } else {
                this.context.sayLetter(event.getChar());
            }
            return true;
        }
        String newLine = new String(line.substring(0, pos) + event.getChar() + line.substring(pos));
        this.model.setLine(newLine);
        this.model.setHotPointX(pos + 1);
        if (event.getChar() == ' ') {
            String lastWord = TextUtils.getLastWord(newLine, pos + 1);
            if (lastWord != null && !lastWord.isEmpty()) {
                this.context.say(lastWord);
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.SPACE));
            }
        } else {
            this.context.sayLetter(event.getChar());
        }
        return true;
    }

    @Override
    public String onRegionTextQuery(int fromX, int fromY, int toX, int toY) {
        int toPos;
        String line = this.model.getLine();
        if (line == null) {
            return null;
        }
        int fromPos = Math.min(fromX, line.length());
        if (fromPos >= (toPos = Math.min(toX, line.length()))) {
            return null;
        }
        return line.substring(fromPos, toPos);
    }

    @Override
    public boolean onClipboardCopyAll() {
        String line = this.model.getLine();
        if (line == null) {
            return false;
        }
        this.context.getClipboard().set(line);
        return true;
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        int toPos;
        String line = this.model.getLine();
        if (line == null) {
            return false;
        }
        int fromPos = Math.min(fromX, line.length());
        if (fromPos >= (toPos = Math.min(toX, line.length()))) {
            return false;
        }
        if (withDeleting && !this.onDeleteRegion(fromX, fromY, toX, toY)) {
            return false;
        }
        String res = line.substring(fromPos, toPos);
        this.context.getClipboard().set(res);
        return true;
    }

    @Override
    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        int toPos;
        String line = this.model.getLine();
        if (line == null || line.isEmpty()) {
            return false;
        }
        int fromPos = Math.min(fromX, line.length());
        if (fromPos >= (toPos = Math.min(toX, line.length()))) {
            return false;
        }
        this.model.setLine(line.substring(0, fromPos) + line.substring(toPos));
        this.model.setHotPointX(fromPos);
        return true;
    }

    protected boolean onClear() {
        this.model.setLine("");
        this.model.setHotPointX(0);
        return true;
    }

    protected boolean onClipboardPaste() {
        String text = this.context.getClipboard().getString(" ");
        if (text.isEmpty()) {
            return false;
        }
        String line = this.model.getLine();
        int pos = Math.min(this.model.getHotPointX(), line.length());
        this.model.setLine(line.substring(0, pos) + text + line.substring(pos));
        this.model.setHotPointX(pos + text.length());
        return true;
    }

    public static interface Model {
        public String getLine();

        public void setLine(String var1);

        public int getHotPointX();

        public void setHotPointX(int var1);

        public String getTabSeq();
    }

    public static final class Params {
        ControlContext context;
        Model model;
        AbstractRegionPoint regionPoint;
        List<InputEventListener> inputEventListeners;
    }

    public static interface InputEventListener {
        public boolean onEditInputEvent(Model var1, InputEvent var2);
    }
}

