/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.Objects;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.controls.edit.TextEditAction;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;
import org.luwrain.util.TextUtils;

public class MultilineEditTranslator
implements MultilineEditCorrector {
    protected final MutableLines lines;
    protected final HotPointControl hotPoint;
    protected String tabSeq = "\t";
    protected boolean hasChanges = false;

    public MultilineEditTranslator(MutableLines lines, HotPointControl hotPoint) {
        Objects.requireNonNull(lines, "lines can't be null");
        Objects.requireNonNull(hotPoint, "hotPoint can't be null");
        this.lines = lines;
        this.hotPoint = hotPoint;
    }

    public MultilineEditTranslator(MutableLines lines, HotPointControl hotPoint, String tabSeq) {
        Objects.requireNonNull(lines, "lines can't be null");
        Objects.requireNonNull(hotPoint, "hotPoint can't be null");
        Objects.requireNonNull(tabSeq, "tabSeq can't be null");
        this.lines = lines;
        this.hotPoint = hotPoint;
        this.tabSeq = tabSeq;
    }

    @Override
    public MultilineEdit.ModificationResult deleteChar(int pos, int lineIndex) {
        if (pos < 0 || lineIndex < 0) {
            throw new IllegalArgumentException("pos (" + pos + ") and lineIndex (" + lineIndex + ") may not be negative");
        }
        this.hasChanges = true;
        int lineCount = this.lines.getLineCount();
        if (lineIndex >= lineCount) {
            throw new IllegalArgumentException("lineIndex (" + lineIndex + ") must be less than the number of lines (" + lineCount + ")");
        }
        String line = this.lines.getLine(lineIndex);
        NullCheck.notNull((Object)line, (String)"line");
        if (pos >= line.length()) {
            throw new IllegalArgumentException("pos (" + pos + ") must be less than the length of the line (" + line.length() + ")");
        }
        this.beginEditTrans();
        this.lines.setLine(lineIndex, line.substring(0, pos) + line.substring(pos + 1));
        if (this.hotPoint.getHotPointY() == lineIndex && this.hotPoint.getHotPointX() > pos) {
            this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - 1);
        }
        this.endEditTrans(true);
        return new MultilineEdit.ModificationResult(true, line.charAt(pos));
    }

    @Override
    public MultilineEdit.ModificationResult deleteRegion(int fromX, int fromY, int toX, int toY) {
        this.hasChanges = true;
        if (this.lines.getLineCount() < 1 || fromY > toY || fromY == toY && fromX > toX || toY >= this.lines.getLineCount()) {
            return new MultilineEdit.ModificationResult(false);
        }
        if (fromY == toY) {
            int toPos;
            String line = this.lines.getLine(fromY);
            NullCheck.notNull((Object)line, (String)"line");
            if (line.isEmpty()) {
                return new MultilineEdit.ModificationResult(false);
            }
            int fromPos = Math.min(fromX, line.length());
            if (fromPos >= (toPos = Math.min(toX, line.length()))) {
                return new MultilineEdit.ModificationResult(false);
            }
            this.beginEditTrans();
            this.lines.setLine(fromY, line.substring(0, fromPos) + line.substring(toPos));
            if (this.hotPoint.getHotPointY() == fromY) {
                if (this.hotPoint.getHotPointX() >= fromPos && this.hotPoint.getHotPointX() < toPos) {
                    this.hotPoint.setHotPointX(fromPos);
                } else if (this.hotPoint.getHotPointX() >= toPos) {
                    this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - (toPos - fromPos));
                }
            }
            this.endEditTrans(true);
            return new MultilineEdit.ModificationResult(true);
        }
        String firstLine = this.lines.getLine(fromY);
        NullCheck.notNull((Object)firstLine, (String)"firstLine");
        int fromPos = Math.min(fromX, firstLine.length());
        String endingLine = this.lines.getLine(toY);
        NullCheck.notNull((Object)endingLine, (String)"endingLine");
        int toPos = Math.min(toX, endingLine.length());
        this.beginEditTrans();
        this.lines.setLine(fromY, firstLine.substring(0, fromPos) + endingLine.substring(toPos));
        for (int i = fromY + 1; i <= toY; ++i) {
            this.lines.removeLine(fromY + 1);
        }
        if (this.hotPoint.getHotPointY() == fromY && this.hotPoint.getHotPointX() >= fromPos || this.hotPoint.getHotPointY() > fromY && this.hotPoint.getHotPointY() < toY || this.hotPoint.getHotPointY() == toY && this.hotPoint.getHotPointX() < toX) {
            this.hotPoint.setHotPointY(fromY);
            this.hotPoint.setHotPointX(fromX);
        } else if (this.hotPoint.getHotPointY() == toY && this.hotPoint.getHotPointX() >= toPos) {
            this.hotPoint.setHotPointY(fromY);
            this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - toPos + fromPos);
        } else if (this.hotPoint.getHotPointY() > toY) {
            this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() - toY + fromY);
        }
        this.endEditTrans(true);
        return new MultilineEdit.ModificationResult(true);
    }

    @Override
    public MultilineEdit.ModificationResult insertRegion(int x, int y, String[] text) {
        NullCheck.notNullItems((Object[])text, (String)"text");
        this.checkPos(x, y);
        this.hasChanges = true;
        if (text.length == 0) {
            return new MultilineEdit.ModificationResult(true);
        }
        String firstLine = text[0];
        String lastLine = text[text.length - 1];
        if (y == 0 && x == 0 && this.lines.getLineCount() == 0) {
            this.beginEditTrans();
            for (int i = 0; i < text.length; ++i) {
                this.lines.addLine(text[i]);
            }
            this.hotPoint.setHotPointX(text[text.length - 1].length());
            this.hotPoint.setHotPointY(this.lines.getLineCount() - 1);
            this.endEditTrans(false);
            return new MultilineEdit.ModificationResult(true);
        }
        if (text.length == 1) {
            String line = this.lines.getLine(y);
            boolean needToMoveHotPoint = this.hotPoint.getHotPointY() == y && x <= this.hotPoint.getHotPointX();
            this.beginEditTrans();
            this.lines.setLine(y, line.substring(0, x) + firstLine + line.substring(x));
            if (needToMoveHotPoint) {
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() + firstLine.length());
            }
            this.endEditTrans(false);
            return new MultilineEdit.ModificationResult(true);
        }
        String line = this.lines.getLine(y);
        this.beginEditTrans();
        this.lines.setLine(y, line.substring(0, x) + text[0]);
        for (int i = 1; i < text.length - 1; ++i) {
            this.lines.insertLine(y + i, text[i]);
        }
        this.lines.insertLine(y + text.length - 1, text[text.length - 1] + line.substring(x));
        if (this.hotPoint.getHotPointY() > y) {
            this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() + text.length - 1);
        } else if (this.hotPoint.getHotPointY() == y && this.hotPoint.getHotPointX() >= x) {
            this.hotPoint.setHotPointY(y + text.length - 1);
            this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - x + lastLine.length());
        }
        this.endEditTrans(false);
        return new MultilineEdit.ModificationResult(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultilineEdit.ModificationResult putChars(int pos, int lineIndex, String str) {
        NullCheck.notNull((Object)str, (String)"str");
        this.checkPos(pos, lineIndex);
        this.hasChanges = true;
        this.beginEditTrans();
        try {
            int count;
            if (pos == 0 && lineIndex == 0 && this.lines.getLineCount() == 0) {
                this.lines.addLine("");
            }
            if (lineIndex >= (count = this.lines.getLineCount())) {
                throw new IllegalArgumentException("lineIndex (" + lineIndex + ") must be less then the number of lines (" + count + ")");
            }
            String line = this.lines.getLine(lineIndex);
            if (pos > line.length()) {
                throw new IllegalArgumentException("pos (" + pos + ") may not be greater than the length of the line (" + line.length() + ")");
            }
            this.lines.setLine(lineIndex, line.substring(0, pos) + str + line.substring(pos));
            if (this.hotPoint.getHotPointY() == lineIndex && this.hotPoint.getHotPointX() >= pos) {
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() + (str != null ? str.length() : 0));
            }
        }
        finally {
            this.endEditTrans(false);
        }
        if (str.length() == 1 && Character.isWhitespace(str.charAt(0))) {
            String word = this.getWordPriorTo(pos, lineIndex);
            if (!word.isEmpty()) {
                return new MultilineEdit.ModificationResult(true, word, str.charAt(0));
            }
            return new MultilineEdit.ModificationResult(true, str.charAt(0));
        }
        if (str.length() == 1) {
            return new MultilineEdit.ModificationResult(true, str.charAt(0));
        }
        return new MultilineEdit.ModificationResult(true, str);
    }

    @Override
    public MultilineEdit.ModificationResult mergeLines(int firstLineIndex) {
        if (firstLineIndex < 0) {
            throw new IllegalArgumentException("firstLineIndex (" + firstLineIndex + ") may not be negative");
        }
        this.hasChanges = true;
        int lineCount = this.lines.getLineCount();
        if (firstLineIndex + 1 >= lineCount) {
            throw new IllegalArgumentException("firstLineIndex (" + firstLineIndex + ") + 1 must be less than the number of lines (" + lineCount + ")");
        }
        this.beginEditTrans();
        String firstLine = this.lines.getLine(firstLineIndex);
        NullCheck.notNull((Object)firstLine, (String)"firstLine");
        int origLineLen = firstLine.length();
        this.lines.setLine(firstLineIndex, firstLine + this.lines.getLine(firstLineIndex + 1));
        this.lines.removeLine(firstLineIndex + 1);
        if (this.hotPoint.getHotPointY() == firstLineIndex + 1) {
            this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() - 1);
            this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() + origLineLen);
        } else if (this.hotPoint.getHotPointY() > firstLineIndex + 1) {
            this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() - 1);
        }
        this.endEditTrans(true);
        return new MultilineEdit.ModificationResult(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultilineEdit.ModificationResult splitLine(int pos, int lineIndex) {
        String newLine;
        this.checkPos(pos, lineIndex);
        this.hasChanges = true;
        this.beginEditTrans();
        try {
            int lineCount;
            if (pos == 0 && lineIndex == 0 && this.lines.getLineCount() == 0) {
                this.lines.addLine("");
            }
            if (lineIndex >= (lineCount = this.lines.getLineCount())) {
                throw new IllegalArgumentException("lineIndex (" + lineIndex + ") must be less than the number of lines (" + lineCount + ")");
            }
            String line = this.lines.getLine(lineIndex);
            NullCheck.notNull((Object)line, (String)"line");
            if (pos > line.length()) {
                throw new IllegalArgumentException("pos (" + pos + ") may not be negative than the length of the line (" + line.length() + ")");
            }
            this.lines.setLine(lineIndex, line.substring(0, pos));
            newLine = line.substring(pos);
            this.lines.insertLine(lineIndex + 1, newLine);
            if (this.hotPoint.getHotPointY() == lineIndex && this.hotPoint.getHotPointX() >= pos) {
                this.hotPoint.setHotPointY(lineIndex + 1);
                this.hotPoint.setHotPointX(this.hotPoint.getHotPointX() - pos);
            } else if (this.hotPoint.getHotPointY() > lineIndex) {
                this.hotPoint.setHotPointY(this.hotPoint.getHotPointY() + 1);
            }
        }
        finally {
            this.endEditTrans(false);
        }
        return new MultilineEdit.ModificationResult(true, newLine);
    }

    @Override
    public MultilineEdit.ModificationResult doEditAction(TextEditAction action) {
        NullCheck.notNull((Object)action, (String)"action");
        this.hasChanges = true;
        action.doTextEdit(this.lines, this.hotPoint);
        return new MultilineEdit.ModificationResult(true);
    }

    boolean commit() {
        if (!this.hasChanges) {
            return false;
        }
        this.hasChanges = false;
        return true;
    }

    @Override
    public int getLineCount() {
        int count = this.lines.getLineCount();
        return count > 0 ? count : 1;
    }

    @Override
    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        if (index == 0 && this.lines.getLineCount() == 0) {
            return "";
        }
        return this.lines.getLine(index);
    }

    @Override
    public int getHotPointX() {
        return this.hotPoint.getHotPointX();
    }

    @Override
    public int getHotPointY() {
        return this.hotPoint.getHotPointY();
    }

    @Override
    public String getTabSeq() {
        return this.tabSeq;
    }

    protected String getWordPriorTo(int pos, int lineIndex) {
        String res = TextUtils.getLastWord(this.getLine(lineIndex), pos);
        if (!res.isEmpty()) {
            return res;
        }
        if (lineIndex == 0) {
            return "";
        }
        for (int i = lineIndex - 1; i >= 0; --i) {
            String line = this.getLine(i);
            res = TextUtils.getLastWord(line, line.length());
            if (res.isEmpty()) continue;
            return res;
        }
        return "";
    }

    protected void checkPos(int pos, int lineIndex) {
        if (pos < 0 || lineIndex < 0) {
            throw new IllegalArgumentException("pos (" + pos + ") and lineIndex (" + lineIndex + ") may not be negative");
        }
        if (this.lines.getLineCount() == 0 && pos == 0 && lineIndex == 0) {
            return;
        }
        if (lineIndex >= this.lines.getLineCount()) {
            throw new IllegalArgumentException("lineIndex (" + lineIndex + ") may not be equal or greater than " + this.lines.getLineCount());
        }
        String line = this.lines.getLine(lineIndex);
        NullCheck.notNull((Object)line, (String)"line");
        if (pos > line.length()) {
            throw new IllegalArgumentException("pos (" + pos + ") may not be greater than " + line.length());
        }
    }

    protected void beginEditTrans() {
        this.hotPoint.beginHotPointTrans();
    }

    protected void endEditTrans(boolean cleanSingleEmptyLine) {
        if (cleanSingleEmptyLine && this.lines.getLineCount() == 1 && this.lines.getLine(0).isEmpty()) {
            this.lines.removeLine(0);
        }
        this.hotPoint.endHotPointTrans();
    }
}

