/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Area;
import org.luwrain.core.NullCheck;

public final class AreaLayout {
    public static final Type SINGLE = Type.SINGLE;
    public static final Type LEFT_RIGHT = Type.LEFT_RIGHT;
    public static final Type TOP_BOTTOM = Type.TOP_BOTTOM;
    public static final Type LEFT_TOP_BOTTOM = Type.LEFT_TOP_BOTTOM;
    public static final Type LEFT_RIGHT_BOTTOM = Type.LEFT_RIGHT_BOTTOM;
    final Type layoutType;
    final Area area1;
    final Area area2;
    final Area area3;

    public AreaLayout(Area area) {
        this.layoutType = SINGLE;
        NullCheck.notNull((Object)area, (String)"area");
        this.area1 = area;
        this.area2 = null;
        this.area3 = null;
    }

    public AreaLayout(Type layoutType, Area area1, Area area2) {
        NullCheck.notNull((Object)((Object)layoutType), (String)"layoutType");
        NullCheck.notNull((Object)area1, (String)"area1");
        NullCheck.notNull((Object)area2, (String)"area2");
        if (layoutType != LEFT_RIGHT && layoutType != TOP_BOTTOM) {
            throw new IllegalArgumentException("Illegal layoutType " + String.valueOf((Object)layoutType));
        }
        this.layoutType = layoutType;
        this.area1 = area1;
        this.area2 = area2;
        this.area3 = null;
    }

    public AreaLayout(Type layoutType, Area area1, Area area2, Area area3) {
        this.layoutType = layoutType;
        this.area1 = area1;
        this.area2 = area2;
        this.area3 = area3;
        NullCheck.notNull((Object)area1, (String)"area1");
        NullCheck.notNull((Object)area2, (String)"area2");
        NullCheck.notNull((Object)area3, (String)"area3");
        if (layoutType != LEFT_TOP_BOTTOM && layoutType != LEFT_RIGHT_BOTTOM) {
            throw new IllegalArgumentException("Illegal layoutType " + String.valueOf((Object)layoutType));
        }
    }

    public AreaLayout(Type layoutType, Area[] areas) {
        NullCheck.notNull((Object)((Object)layoutType), (String)"layoutType");
        NullCheck.notNullItems((Object[])areas, (String)"areas");
        this.layoutType = layoutType;
        switch (layoutType) {
            case SINGLE: {
                if (areas.length < 1) {
                    throw new IllegalArgumentException("areas array must have at least one element");
                }
                NullCheck.notNull((Object)areas[0], (String)"areas[0]");
                this.area1 = areas[0];
                this.area2 = null;
                this.area3 = null;
                return;
            }
            case LEFT_RIGHT: 
            case TOP_BOTTOM: {
                if (areas.length < 2) {
                    throw new IllegalArgumentException("areas array must have at least two elements");
                }
                NullCheck.notNull((Object)areas[0], (String)"areas[0]");
                NullCheck.notNull((Object)areas[1], (String)"areas[1]");
                this.area1 = areas[0];
                this.area2 = areas[1];
                this.area3 = null;
                return;
            }
            case LEFT_TOP_BOTTOM: 
            case LEFT_RIGHT_BOTTOM: {
                if (areas.length < 3) {
                    throw new IllegalArgumentException("areas array must have at least three elements");
                }
                NullCheck.notNull((Object)areas[0], (String)"areas[0]");
                NullCheck.notNull((Object)areas[1], (String)"areas[1]");
                NullCheck.notNull((Object)areas[2], (String)"areas[2]");
                this.area1 = areas[0];
                this.area2 = areas[1];
                this.area3 = areas[2];
                return;
            }
        }
        throw new IllegalArgumentException("Illegal layoutType " + layoutType.toString());
    }

    public boolean isValid() {
        switch (this.layoutType) {
            case SINGLE: {
                return this.area1 != null;
            }
            case LEFT_RIGHT: 
            case TOP_BOTTOM: {
                return this.area1 != null && this.area2 != null;
            }
            case LEFT_TOP_BOTTOM: 
            case LEFT_RIGHT_BOTTOM: {
                return this.area1 != null && this.area2 != null && this.area3 != null;
            }
        }
        return false;
    }

    public Area[] getAreas() {
        switch (this.layoutType) {
            case SINGLE: {
                return new Area[]{this.area1};
            }
            case LEFT_RIGHT: 
            case TOP_BOTTOM: {
                return new Area[]{this.area1, this.area2};
            }
            case LEFT_TOP_BOTTOM: 
            case LEFT_RIGHT_BOTTOM: {
                return new Area[]{this.area1, this.area2, this.area3};
            }
        }
        return new Area[0];
    }

    public Area getDefaultArea() {
        return this.area1;
    }

    public boolean hasArea(Area area) {
        switch (this.layoutType) {
            case SINGLE: {
                return this.area1 == area;
            }
            case LEFT_TOP_BOTTOM: {
                return this.area1 == area || this.area2 == area || this.area3 == area;
            }
            case LEFT_RIGHT_BOTTOM: {
                return this.area1 == area || this.area2 == area || this.area3 == area;
            }
        }
        return false;
    }

    public Area getNextArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        Area[] areas = this.getAreas();
        if (areas.length == 0) {
            return null;
        }
        if (areas.length == 1) {
            return areas[0] == area ? area : null;
        }
        if (areas[areas.length - 1] == area) {
            return areas[0];
        }
        for (int i = 0; i < areas.length - 1; ++i) {
            if (areas[i] != area) continue;
            return areas[i + 1];
        }
        return null;
    }

    public Area getPrevArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        Area[] areas = this.getAreas();
        if (areas.length == 0) {
            return null;
        }
        if (areas.length == 1) {
            return areas[0] == area ? area : null;
        }
        if (areas[0] == area) {
            return areas[areas.length - 1];
        }
        for (int i = 0; i < areas.length - 1; ++i) {
            if (areas[i + 1] != area) continue;
            return areas[i];
        }
        return null;
    }

    public static enum Type {
        SINGLE,
        LEFT_RIGHT,
        TOP_BOTTOM,
        LEFT_TOP_BOTTOM,
        LEFT_RIGHT_BOTTOM;

    }
}

