/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.EventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.resp.HintResponse;
import org.luwrain.core.events.resp.LetterResponse;
import org.luwrain.core.events.resp.ListItemResponse;
import org.luwrain.core.events.resp.TextResponse;
import org.luwrain.core.events.resp.TreeItemResponse;

public class DefaultEventResponse {
    public static EventResponse text(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return new TextResponse(null, text);
    }

    public static EventResponse text(Sounds sound, String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return new TextResponse(sound, text);
    }

    public static EventResponse letter(char letter) {
        if (Character.isWhitespace(letter) || letter == '\u00a0') {
            return new HintResponse(Hint.SPACE);
        }
        return new LetterResponse(letter);
    }

    public static EventResponse hint(Hint hint) {
        NullCheck.notNull((Object)((Object)hint), (String)"hint");
        return new HintResponse(hint);
    }

    public static EventResponse hint(Hint hint, String text) {
        NullCheck.notNull((Object)((Object)hint), (String)"hint");
        NullCheck.notNull((Object)text, (String)"text");
        return new HintResponse(hint, text);
    }

    public static EventResponse listItem(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return new ListItemResponse(null, text, null);
    }

    public static EventResponse listItem(String text, Suggestions suggestion) {
        NullCheck.notNull((Object)text, (String)"text");
        return new ListItemResponse(null, text, suggestion);
    }

    public static EventResponse listItem(Sounds sound, String text, Suggestions suggestion) {
        NullCheck.notNull((Object)text, (String)"text");
        return new ListItemResponse(sound, text, suggestion);
    }

    public static TreeItemResponse treeItem(TreeItemResponse.Type type, String text, int level, Suggestions suggestion) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)text, (String)"text");
        return new TreeItemResponse(type, text, level, suggestion);
    }

    public static EventResponse treeItem(TreeItemResponse.Type type, String text, int level) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        NullCheck.notNull((Object)text, (String)"text");
        return new TreeItemResponse(type, text, level);
    }
}

