/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import com.beust.jcommander.ParameterException;
import java.io.File;
import org.luwrain.core.Args;
import org.luwrain.core.Launch;
import org.luwrain.core.Launcher;

public final class LauncherImpl
implements Launcher {
    private static final String ENV_WIN_APP_DATA = "APPDATA";
    private static final String ENV_WIN_USER_PROFILE = "USERPROFILE";
    private static final String WIN_APP_DATA = System.getenv("APPDATA");
    private static final String WIN_USER_PROFILE = System.getenv("USERPROFILE");
    private static final String WIN_USER_DATA_DIR_NAME = "Luwrain";

    public void launch(String[] args) {
        Args a;
        try {
            a = Args.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println("ERROR: luwrain:" + ex.getMessage());
            System.exit(1);
            return;
        }
        File appDir = new File(a.appDir);
        File dataDir = this.getDataDir(a, appDir);
        File userHomeDir = this.getUserHomeDir(a);
        File userDataDir = this.getUserDataDir(a, userHomeDir);
        if (a.printDirs) {
            System.out.println("App: " + appDir.getAbsolutePath());
            System.out.println("Data: " + dataDir.getAbsolutePath());
            System.out.println("User home: " + userHomeDir.getAbsolutePath());
            System.out.println("User data: " + userDataDir.getAbsolutePath());
            return;
        }
        new Launch(a, appDir, dataDir, userDataDir, userHomeDir, a.lang != null ? a.lang.trim() : "en").run();
    }

    private File getDataDir(Args args, File appDir) {
        return new File(appDir, "data");
    }

    private File getUserHomeDir(Args args) {
        return new File(System.getProperty("user.home"));
    }

    private File getUserDataDir(Args args, File userHomeDir) {
        if (WIN_APP_DATA != null && !WIN_APP_DATA.trim().isEmpty()) {
            return new File(new File(WIN_APP_DATA), WIN_USER_DATA_DIR_NAME);
        }
        if (WIN_USER_PROFILE != null && !WIN_USER_PROFILE.trim().isEmpty()) {
            return new File(new File(new File(new File(WIN_USER_PROFILE), "Local Settings"), "Application Data"), WIN_USER_DATA_DIR_NAME);
        }
        return new File(new File(new File(userHomeDir, ".local"), "luwrain"), "default");
    }
}

