/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.popups.EditListPopup;
import org.luwrain.popups.EditListPopupUtils;
import org.luwrain.popups.FileAcceptance;

public class FilePopup
extends EditListPopup {
    static final String SEPARATOR = System.getProperty("file.separator");
    protected final File defaultDir;
    protected final FileAcceptance acceptance;

    public FilePopup(Luwrain luwrain, String name, String prefix, FileAcceptance acceptance, File startFrom, File defaultDir, Set<Flags> flags, Set<Popup.Flags> popupFlags) {
        super(luwrain, new Model(defaultDir, flags.contains((Object)Flags.SKIP_HIDDEN)), name, prefix, FilePopup.getPathWithEndingSeparator(startFrom), popupFlags);
        this.defaultDir = defaultDir;
        this.acceptance = acceptance;
        if (!defaultDir.isDirectory()) {
            throw new IllegalArgumentException(defaultDir.getAbsolutePath() + " must address a directory");
        }
        if (!defaultDir.isAbsolute()) {
            throw new IllegalArgumentException(defaultDir.getAbsolutePath() + " must be absolute");
        }
    }

    public File result() {
        File res = new File(this.text());
        if (res.isAbsolute()) {
            return res;
        }
        return new File(this.defaultDir, this.text());
    }

    @Override
    protected String getSpeakableText(String prefix, String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return prefix + this.luwrain.getSpeakableText(text, Luwrain.SpeakableTextType.PROGRAMMING);
    }

    @Override
    public boolean onOk() {
        if (this.result() == null) {
            return false;
        }
        return this.acceptance != null ? this.acceptance.isPathAcceptable(this.result(), true) : true;
    }

    static String getPathWithEndingSeparator(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        String str = file.toString();
        if (str.endsWith(SEPARATOR)) {
            return str;
        }
        if (file.exists() && file.isDirectory()) {
            return str + SEPARATOR;
        }
        return str;
    }

    protected static class Model
    extends EditListPopupUtils.DynamicModel {
        protected final File defPath;
        protected final boolean skipHidden;

        Model(File defPath, boolean skipHidden) {
            NullCheck.notNull((Object)defPath, (String)"defPath");
            this.defPath = defPath;
            if (!defPath.isAbsolute()) {
                throw new IllegalArgumentException("defPath must be absolute");
            }
            this.skipHidden = skipHidden;
        }

        @Override
        protected EditListPopup.Item[] getItems(String context) {
            File path;
            File base;
            NullCheck.notNull((Object)context, (String)"context");
            if (context.isEmpty()) {
                return this.readDirectory(this.defPath, this.defPath);
            }
            File contextPath = new File(context);
            NullCheck.notNull((Object)contextPath, (String)"contextPath");
            if (contextPath.isAbsolute()) {
                base = null;
                path = contextPath;
            } else {
                base = this.defPath;
                path = new File(this.defPath, contextPath.toString());
            }
            if (!context.endsWith(SEPARATOR) && path.getParent() != null) {
                path = path.getParentFile();
            }
            if (!path.exists() || !path.isDirectory()) {
                return new EditListPopup.Item[0];
            }
            return this.readDirectory(path, base);
        }

        @Override
        protected EditListPopup.Item getEmptyItem(String context) {
            NullCheck.notNull((Object)context, (String)"context");
            if (context.isEmpty()) {
                return new EditListPopupUtils.DefaultItem();
            }
            File base = null;
            File path = new File(context);
            if (!path.isAbsolute()) {
                base = this.defPath;
                path = new File(this.defPath, path.toString());
            }
            if (context.endsWith(SEPARATOR) && path.exists() && path.isDirectory()) {
                return new EditListPopupUtils.DefaultItem(context);
            }
            if ((path = path.getParentFile()) != null) {
                String suffix = "";
                if (path.exists() && path.isDirectory() && !Model.isRoot(path) && (base == null || !base.equals(path))) {
                    suffix = SEPARATOR;
                }
                if (base != null) {
                    return new EditListPopupUtils.DefaultItem(Model.relativize(path, base) + suffix);
                }
                return new EditListPopupUtils.DefaultItem(path.toString() + suffix);
            }
            return new EditListPopupUtils.DefaultItem(context);
        }

        @Override
        public String getCompletion(String beginning) {
            boolean withSlash;
            String res = super.getCompletion(beginning);
            NullCheck.notNull((Object)res, (String)"res");
            String path = beginning + res;
            if (!path.isEmpty() && path.endsWith(SEPARATOR)) {
                return res;
            }
            File pp = new File(path);
            if (!pp.isAbsolute()) {
                pp = new File(this.defPath, pp.toString());
            }
            if ((withSlash = pp.exists() && pp.isDirectory()) && !this.hasWithSameBeginningNearby(pp)) {
                return res + SEPARATOR;
            }
            return res;
        }

        protected EditListPopup.Item[] readDirectory(File dir, File base) {
            NullCheck.notNull((Object)dir, (String)"dir");
            File[] files = dir.listFiles();
            if (files == null) {
                return new EditListPopup.Item[0];
            }
            ArrayList<EditListPopupUtils.DefaultItem> items = new ArrayList<EditListPopupUtils.DefaultItem>();
            for (File pp : dir.listFiles()) {
                if (this.skipHidden && pp.isHidden()) continue;
                if (base != null) {
                    items.add(new EditListPopupUtils.DefaultItem(Model.relativize(pp, base), pp.getName()));
                    continue;
                }
                items.add(new EditListPopupUtils.DefaultItem(pp.toString(), pp.getName()));
            }
            Object[] res = items.toArray(new EditListPopup.Item[items.size()]);
            Arrays.sort(res);
            return res;
        }

        protected boolean hasWithSameBeginningNearby(File path) {
            NullCheck.notNull((Object)path, (String)"path");
            File parent = path.getParentFile();
            if (parent == null) {
                return false;
            }
            String fileName = path.getName();
            File[] files = parent.listFiles();
            if (files == null) {
                return false;
            }
            for (File pp : files) {
                String name;
                if (this.skipHidden && pp.isHidden() || (name = pp.getName()).isEmpty() || name.length() <= fileName.length() || !name.startsWith(fileName)) continue;
                return true;
            }
            return false;
        }

        protected static String relativize(File file, File base) {
            NullCheck.notNull((Object)file, (String)"file");
            String itemStr = file.toString();
            String baseStr = base.toString();
            if (itemStr.startsWith(baseStr + SEPARATOR)) {
                return itemStr.substring(baseStr.length() + 1);
            }
            return itemStr;
        }

        protected static boolean isRoot(File file) {
            NullCheck.notNull((Object)file, (String)"file");
            for (File root : File.listRoots()) {
                if (!file.equals(root)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Flags {
        SKIP_HIDDEN;

    }
}

