/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.util.Set;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.popups.PopupClosingTranslator;

public class ListPopupBase<E>
extends ListArea<E>
implements Popup,
PopupClosingTranslator.Provider {
    protected final PopupClosingTranslator closing = new PopupClosingTranslator(this);
    protected final Luwrain luwrain;
    protected final Set<Popup.Flags> popupFlags;

    public ListPopupBase(Luwrain luwrain, ListArea.Params<E> params, Set<Popup.Flags> popupFlags) {
        super(params);
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull(popupFlags, (String)"popupFlags");
        this.luwrain = luwrain;
        this.popupFlags = popupFlags;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.closing.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.closing.onSystemEvent(event)) {
            return true;
        }
        switch (event.getCode()) {
            case INTRODUCE: {
                this.luwrain.speak(this.getAreaName(), Sounds.POPUP);
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean onOk() {
        return true;
    }

    @Override
    public boolean onCancel() {
        return true;
    }

    @Override
    public Luwrain getLuwrainObject() {
        return this.luwrain;
    }

    @Override
    public boolean isPopupActive() {
        return this.closing.continueEventLoop();
    }

    public boolean wasCancelled() {
        return this.closing.cancelled();
    }

    @Override
    public Set<Popup.Flags> getPopupFlags() {
        return this.popupFlags;
    }
}

