/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.script.core.Bindings;
import org.luwrain.script.core.InternalCoreFuncs;
import org.luwrain.script.core.LuwrainObj;

public final class Module
implements AutoCloseable {
    final Context context;
    final Object syncObj = new Object();
    private final Luwrain luwrain;
    final InternalCoreFuncs internalCoreFuncs;
    final LuwrainObj luwrainObj;

    public Module(Luwrain luwrain, InternalCoreFuncs internalCoreFuncs, Bindings bindings) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.internalCoreFuncs = internalCoreFuncs;
        Engine engine = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").build();
        this.context = Context.newBuilder((String[])new String[]{"js"}).engine(engine).allowExperimentalOptions(true).allowHostAccess(HostAccess.ALL).option("js.interop-complete-promises", "false").build();
        this.luwrainObj = new LuwrainObj(luwrain, this.syncObj, this);
        this.context.getBindings("js").putMember("Luwrain", (Object)this.luwrainObj);
        if (bindings != null) {
            bindings.onBindings(this.context.getBindings("js"), this.luwrainObj.syncObj);
        }
    }

    public Module(Luwrain luwrain, Bindings bindings) {
        this(luwrain, null, bindings);
    }

    public Module(Luwrain luwrain) {
        this(luwrain, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String exp) {
        Object object = this.syncObj;
        synchronized (object) {
            return this.context.eval("js", (CharSequence)exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execFuncValue(Value func) {
        Object object = this.syncObj;
        synchronized (object) {
            func.execute(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value execNewInstance(Value construct, Object[] args) {
        Object object = this.syncObj;
        synchronized (object) {
            return construct.newInstance(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.syncObj;
        synchronized (object) {
            this.context.close();
        }
    }
}

