/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.popups.Popups;
import org.luwrain.script.ScriptUtils;

public final class PopupsObj {
    private final Luwrain luwrain;
    @HostAccess.Export
    public final ProxyExecutable confirmDefaultYes = this::confirmDefaultYesImpl;
    @HostAccess.Export
    public final ProxyExecutable confirmDefaultNo = this::confirmDefaultNoImpl;
    @HostAccess.Export
    public final ProxyExecutable text = this::textImpl;

    PopupsObj(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
    }

    private Boolean confirmDefaultYesImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return false;
        }
        if (!args[0].isString() || !args[1].isString()) {
            return false;
        }
        return Popups.confirmDefaultYes(this.luwrain, args[0].asString(), args[1].asString());
    }

    private Boolean confirmDefaultNoImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return false;
        }
        if (!args[0].isString() || !args[1].isString()) {
            return false;
        }
        return Popups.confirmDefaultNo(this.luwrain, args[0].asString(), args[1].asString());
    }

    private String textImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 3)) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isString()) continue;
            return null;
        }
        String name = args[0].asString();
        String text = args[1].asString();
        String defaultValue = args[2].asString();
        return Popups.text(this.luwrain, name, text, defaultValue);
    }
}

