/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.ml;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.luwrain.core.NullCheck;
import org.luwrain.script.ScriptUtils;

public class JSoupNodeObj {
    final Node node;
    @HostAccess.Export
    public ProxyExecutable getChildNodes = this::getChildNodesImpl;
    @HostAccess.Export
    public ProxyExecutable getTagName = this::getTagNameImpl;
    @HostAccess.Export
    public ProxyExecutable getText = this::getTextImpl;
    @HostAccess.Export
    public ProxyExecutable getType = this::getTypeImpl;
    @HostAccess.Export
    public ProxyExecutable find = this::findImpl;

    JSoupNodeObj(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.node = node;
    }

    private Object getChildNodesImpl(Value[] args) {
        List childNodes = this.node.childNodes();
        if (childNodes == null) {
            return null;
        }
        ArrayList<JSoupNodeObj> res = new ArrayList<JSoupNodeObj>();
        for (Node i : childNodes) {
            res.add(new JSoupNodeObj(i));
        }
        return ProxyArray.fromArray((Object[])res.toArray(new JSoupNodeObj[res.size()]));
    }

    private Object getTagNameImpl(Value[] args) {
        Node node = this.node;
        if (node instanceof Element) {
            Element el = (Element)node;
            return el.tagName();
        }
        throw new IllegalArgumentException("This node is not an element, unable to call getTagName()");
    }

    private Object getTextImpl(Value[] args) {
        return this.node.toString();
    }

    private Object getTypeImpl(Value[] args) {
        return this.node.getClass().getSimpleName();
    }

    private Object findImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 1) || !args[0].canExecute()) {
            throw new IllegalArgumentException("Node.find() takes exactly one function argument");
        }
        List nodes = this.node.childNodes();
        if (nodes == null) {
            return null;
        }
        for (Node n : nodes) {
            JSoupNodeObj obj = new JSoupNodeObj(n);
            Value res = args[0].execute(new Object[]{obj});
            if (res == null || !res.isBoolean() || !res.asBoolean()) continue;
            return obj;
        }
        return null;
    }
}

