/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.luwrain.core.NullCheck;

public final class StreamUtils {
    public static final int BUF_SIZE = 2048;

    public static long copyAllBytes(InputStream is, OutputStream os) throws IOException {
        return StreamUtils.copyAllBytes(is, os, null, null);
    }

    public static long copyAllBytes(InputStream is, OutputStream os, Progress progress, Interrupting interrupting) throws IOException {
        NullCheck.notNull((Object)is, (String)"is");
        NullCheck.notNull((Object)os, (String)"os");
        long totalBytes = 0L;
        byte[] buf = new byte[2048];
        while (interrupting == null || !interrupting.interrupting()) {
            int length = is.read(buf);
            if (length < 0) {
                return totalBytes;
            }
            StreamUtils.writeAllBytes(os, buf, length);
            totalBytes += (long)length;
            if (progress == null) continue;
            progress.processed(length, totalBytes);
        }
        return totalBytes;
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        NullCheck.notNull((Object)is, (String)"is");
        byte[] buf = new byte[2048];
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        int length = 0;
        do {
            if ((length = is.read(buf)) <= 0) continue;
            res.write(buf, 0, length);
        } while (length >= 0);
        return res.toByteArray();
    }

    public static void writeAllBytes(OutputStream os, byte[] bytes) throws IOException {
        NullCheck.notNull((Object)os, (String)"os");
        NullCheck.notNull((Object)bytes, (String)"bytes");
        StreamUtils.writeAllBytes(os, bytes, bytes.length);
    }

    public static void writeAllBytes(OutputStream os, byte[] bytes, int numBytes) throws IOException {
        int numToWrite;
        NullCheck.notNull((Object)os, (String)"os");
        NullCheck.notNull((Object)bytes, (String)"bytes");
        if (numBytes < 0) {
            throw new IllegalArgumentException("numBytes (" + String.valueOf(numBytes) + ") can't be negative");
        }
        if (numBytes == 0) {
            return;
        }
        int pos = 0;
        do {
            int remaining;
            numToWrite = (remaining = numBytes - pos) > 2048 ? 2048 : remaining;
            os.write(bytes, pos, numToWrite);
        } while ((pos += numToWrite) < numBytes);
    }

    public static interface Progress {
        public void processed(int var1, long var2);
    }

    public static interface Interrupting {
        public boolean interrupting();
    }
}

