/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import org.luwrain.core.NullCheck;

public class WordIterator {
    protected final String line;
    protected int pos = 0;
    protected String announce = "";

    public WordIterator(String line, int pos) {
        NullCheck.notNull((Object)line, (String)"line");
        if (pos < 0) {
            throw new IllegalArgumentException("pos may not be negative (" + pos + ")");
        }
        if (this.pos > line.length()) {
            throw new IllegalArgumentException("pos may not be greater than the length of provided line (" + pos + ")");
        }
        this.line = line;
        this.pos = pos;
        this.announce = "";
    }

    public boolean stepForward() {
        if (this.pos >= this.line.length()) {
            return false;
        }
        this.pos = this.getNextBorder(this.pos);
        if (this.pos >= this.line.length()) {
            this.announce = "";
            return true;
        }
        int nextPos = this.getNextBorder(this.pos);
        this.announce = this.line.substring(this.pos, nextPos);
        return true;
    }

    public boolean stepBackward() {
        if (this.pos <= 0) {
            return false;
        }
        this.pos = this.getPrevBorder(this.pos);
        int nextPos = this.getNextBorder(this.pos);
        this.announce = this.line.substring(this.pos, nextPos);
        return true;
    }

    public int pos() {
        return this.pos;
    }

    public String announce() {
        return this.announce;
    }

    private int getNextBorder(int current) {
        int i;
        if (current < 0 || current > this.line.length()) {
            throw new IllegalArgumentException("current must be inside of the line");
        }
        if (current + 1 >= this.line.length()) {
            return this.line.length();
        }
        for (i = current + 1; i < this.line.length() && (!this.isLetterDigit(this.line.charAt(i)) || this.isLetterDigit(this.line.charAt(i - 1))); ++i) {
        }
        return i;
    }

    private int getPrevBorder(int current) {
        int i;
        if (current < 0 || current > this.line.length()) {
            throw new IllegalArgumentException("current must be inside of the line");
        }
        if (current <= 1) {
            return 0;
        }
        for (i = current - 1; i > 1 && (!this.isLetterDigit(this.line.charAt(i)) || this.isLetterDigit(this.line.charAt(i - 1))); --i) {
        }
        if (!this.isLetterDigit(this.line.charAt(i - 1)) && this.isLetterDigit(this.line.charAt(i))) {
            return i;
        }
        return 0;
    }

    private boolean isLetterDigit(char ch) {
        return Character.isDigit(ch) || Character.isLetter(ch);
    }
}

