/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.en;

import java.util.Date;
import org.luwrain.core.NullCheck;

class DateUtils {
    private final Date now = new Date();

    DateUtils() {
    }

    String passedTimeFull(Date moment) {
        NullCheck.notNull((Object)moment, (String)"moment");
        long wasTime = moment.getTime();
        long nowTime = this.now.getTime();
        long passed = nowTime - wasTime;
        long secondsTotal = passed / 1000L;
        long minutesTotal = secondsTotal / 60L;
        long seconds = secondsTotal - minutesTotal * 60L;
        long hoursTotal = minutesTotal / 60L;
        long minutes = minutesTotal - hoursTotal * 60L;
        long daysTotal = hoursTotal / 24L;
        long hours = hoursTotal - daysTotal * 24L;
        long weeksTotal = daysTotal / 7L;
        long days = daysTotal - weeksTotal * 7L;
        String res = seconds + "sec";
        if (minutes > 0L) {
            res = minutes + "min " + res;
        }
        if (hours > 0L) {
            res = hours + "h " + res;
        }
        if (daysTotal > 0L) {
            res = daysTotal + "d " + res;
        }
        return res;
    }

    String pastTimeBrief(Date moment) {
        NullCheck.notNull((Object)moment, (String)"moment");
        long wasTime = moment.getTime();
        long nowTime = this.now.getTime();
        long passed = nowTime - wasTime;
        long secondsTotal = passed / 1000L;
        long minutesTotal = secondsTotal / 60L;
        long hoursTotal = minutesTotal / 60L;
        long daysTotal = hoursTotal / 24L;
        long weeksTotal = daysTotal / 7L;
        if (weeksTotal > 0L) {
            return weeksTotal + " " + (weeksTotal == 1L ? "week" : "weeks");
        }
        if (daysTotal > 0L) {
            return daysTotal + " " + (daysTotal == 1L ? "day" : "days");
        }
        if (hoursTotal > 0L) {
            return hoursTotal + " " + (hoursTotal == 1L ? "hour" : "hours");
        }
        if (minutesTotal > 0L) {
            return minutesTotal + " " + (minutesTotal == 1L ? "minute" : "minutes");
        }
        if (secondsTotal > 0L) {
            return secondsTotal + " " + (secondsTotal == 1L ? "second" : "seconds");
        }
        return "less than second";
    }

    static String dateTime(Date moment) {
        NullCheck.notNull((Object)moment, (String)"moment");
        StringBuilder b = new StringBuilder();
        b.append(DateUtils.addZeroes(moment.getHours(), 2) + ":" + DateUtils.addZeroes(moment.getMinutes(), 2));
        b.append(", ");
        b.append(DateUtils.date(moment));
        return new String(b);
    }

    static String date(Date moment) {
        NullCheck.notNull((Object)moment, (String)"moment");
        return DateUtils.month(moment.getMonth() + 1) + " " + moment.getDate() + ", " + (moment.getYear() + 1900) + "\u0433.";
    }

    private static String month(int m) {
        switch (m) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "";
    }

    private static String addZeroes(int num, int z) {
        String res = "" + num;
        while (res.length() < z) {
            res = "0" + res;
        }
        return res;
    }
}

