/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n.en;

import java.util.Date;
import java.util.Map;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.i18n.LangBase;
import org.luwrain.i18n.en.DateUtils;

final class Lang
extends LangBase {
    Lang(Luwrain luwrain, Map<String, String> staticStrings, Map<String, String> chars) {
        super("en", luwrain, staticStrings, chars);
    }

    public String getNumberStr(int num, String entities) {
        NullCheck.notEmpty((Object)entities, (String)"entities");
        StringBuilder b = new StringBuilder();
        b.append(num + " ");
        switch (entities) {
            case "items": {
                b.append(num == 1 ? "item" : "items");
                break;
            }
            case "percents": {
                b.append(num == 1 ? "percent" : "percents");
                break;
            }
            case "hours": {
                b.append(num == 1 ? "hour" : "hours");
                break;
            }
            case "minutes": {
                b.append(num == 1 ? "minute" : "minutes");
            }
        }
        return new String(b);
    }

    public String pastTimeBrief(Date date) {
        NullCheck.notNull((Object)date, (String)"date");
        return new DateUtils().pastTimeBrief(date) + " ago";
    }

    public String getSpeakableText(String text, Luwrain.SpeakableTextType type) {
        return text;
    }

    public String hasSpecialNameOfChar(char ch) {
        String value = super.hasSpecialNameOfChar(ch);
        if (value == null) {
            return null;
        }
        if (value.endsWith("_sign")) {
            return value.substring(0, value.length() - 5);
        }
        return value;
    }
}

