/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.commander.Conv;
import org.luwrain.app.commander.Hooks;
import org.luwrain.app.commander.MainLayout;
import org.luwrain.app.commander.OperationsLayout;
import org.luwrain.app.commander.Settings;
import org.luwrain.app.commander.Strings;
import org.luwrain.app.commander.fileops.Operation;
import org.luwrain.app.commander.fileops.OperationListener;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;

public final class App
extends AppBase<Strings> {
    final String startFrom;
    final List<Operation> operations = new ArrayList<Operation>();
    final OperationListener opListener = this.newOperationListener();
    private Settings sett = null;
    private Conv conv = null;
    private Hooks hooks = null;
    private MainLayout mainLayout = null;
    private OperationsLayout operationsLayout = null;

    App(String startFrom) {
        super(Strings.class, "luwrain.commander");
        this.startFrom = startFrom != null && !startFrom.isEmpty() ? startFrom : null;
    }

    App() {
        this(null);
    }

    public AreaLayout onAppInit() {
        this.sett = null;
        this.conv = new Conv(this);
        this.hooks = new Hooks(this);
        this.mainLayout = new MainLayout(this);
        this.operationsLayout = new OperationsLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    void runOperation(Operation op) {
        this.operations.add(0, op);
        this.getLuwrain().executeBkg(new FutureTask<Object>(op, null));
    }

    boolean allOperationsFinished() {
        for (Operation op : this.operations) {
            if (op.isDone()) continue;
            return false;
        }
        return true;
    }

    boolean closeOperation(int index) {
        if (index < 0 || index >= this.operations.size()) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + ") must be positive and less than the number of operations (" + String.valueOf(this.operations.size()) + ")");
        }
        if (!this.operations.get(index).isDone()) {
            return false;
        }
        this.operations.remove(index);
        this.operationsLayout.operationsArea.refresh();
        return true;
    }

    String getOperationResultDescr(Operation op) {
        return "";
    }

    private OperationListener newOperationListener() {
        return new OperationListener(){

            @Override
            public void onOperationProgress(Operation operation) {
                App.this.getLuwrain().runUiSafely(() -> {
                    App.this.operationsLayout.operationsArea.redraw();
                    if (operation.isDone()) {
                        if (operation.getException() == null) {
                            App.this.getLuwrain().playSound(Sounds.DONE);
                        } else {
                            App.this.getLuwrain().playSound(Sounds.ERROR);
                        }
                        App.this.mainLayout.leftPanel.reread(false);
                        App.this.mainLayout.rightPanel.reread(false);
                    }
                });
            }
        };
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public void closeApp() {
        if (!this.allOperationsFinished()) {
            this.getLuwrain().message(((Strings)this.getStrings()).notAllOperationsFinished(), Luwrain.MessageType.ERROR);
            return;
        }
        if (this.mainLayout != null) {
            this.mainLayout.leftPanel.close();
            this.mainLayout.rightPanel.close();
        }
        super.closeApp();
    }

    void layout(AreaLayout layout) {
        this.getLayout().setBasicLayout(layout);
        this.getLuwrain().announceActiveArea();
    }

    void layout(AreaLayout layout, Area activeArea) {
        this.getLayout().setBasicLayout(layout);
        this.getLuwrain().announceActiveArea();
        this.getLuwrain().setActiveArea(activeArea);
    }

    public Layouts layouts() {
        return new Layouts(){

            @Override
            public void main() {
                App.this.setAreaLayout(App.this.mainLayout);
                App.this.getLuwrain().announceActiveArea();
            }

            @Override
            public void operations() {
                App.this.setAreaLayout(App.this.operationsLayout);
                App.this.getLuwrain().announceActiveArea();
            }
        };
    }

    Settings getSett() {
        return this.sett;
    }

    Conv getConv() {
        return this.conv;
    }

    Hooks getHooks() {
        return this.hooks;
    }

    public static interface Layouts {
        public void main();

        public void operations();
    }

    static enum Side {
        LEFT,
        RIGHT;

    }
}

