/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.commander;

import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import org.apache.commons.vfs2.FileObject;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.commander.App;
import org.luwrain.app.commander.FileActions;
import org.luwrain.app.commander.FilesInfoLayout;
import org.luwrain.app.commander.PanelArea;
import org.luwrain.app.commander.Strings;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.util.Urls;

final class MainLayout
extends LayoutBase {
    private final App app;
    final PanelArea leftPanel;
    final PanelArea rightPanel;
    private final FileActions fileActions;

    MainLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        this.fileActions = new FileActions(app);
        CommanderArea.Params<FileObject> params = PanelArea.createParams(this.getControlContext());
        params.clickHandler = this::onClick;
        this.leftPanel = new PanelArea(params, this.getLuwrain()){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case SAVE: {
                            app.layouts().operations();
                            return true;
                        }
                        case INTRODUCE: {
                            return MainLayout.this.announcePanel(App.Side.LEFT);
                        }
                        case PROPERTIES: {
                            return MainLayout.this.showFilesInfo(this);
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.rightPanel = new PanelArea(params, this.getLuwrain()){

            public boolean onSystemEvent(SystemEvent event) {
                if (event.getType() == SystemEvent.Type.REGULAR) {
                    switch (event.getCode()) {
                        case SAVE: {
                            app.layouts().operations();
                            return true;
                        }
                        case INTRODUCE: {
                            return MainLayout.this.announcePanel(App.Side.RIGHT);
                        }
                        case PROPERTIES: {
                            return MainLayout.this.showFilesInfo(this);
                        }
                    }
                }
                return super.onSystemEvent(event);
            }
        };
        this.setAreaLayout(AreaLayout.LEFT_RIGHT, (Area)this.leftPanel, this.getPanelActions(App.Side.LEFT), (Area)this.rightPanel, this.getPanelActions(App.Side.RIGHT));
        if (app.startFrom != null) {
            this.leftPanel.openInitial(app.startFrom);
            this.rightPanel.openInitial(app.startFrom);
        } else {
            String location = app.getLuwrain().getDir("~");
            this.leftPanel.openInitial(location);
            this.rightPanel.openInitial(location);
        }
    }

    private LayoutBase.Actions getPanelActions(App.Side side) {
        PanelArea oppositePanelArea;
        PanelArea panelArea;
        if (side == App.Side.LEFT) {
            panelArea = this.leftPanel;
            oppositePanelArea = this.rightPanel;
        } else {
            panelArea = this.rightPanel;
            oppositePanelArea = this.leftPanel;
        }
        return this.actions(this.app.getHooks().panelActions(this, panelArea, oppositePanelArea), new LayoutBase.ActionInfo[]{this.action("copy", ((Strings)this.app.getStrings()).actionCopy(), new InputEvent(InputEvent.Special.F5), () -> this.fileActions.localCopy(panelArea, oppositePanelArea)), this.action("move", ((Strings)this.app.getStrings()).actionMove(), new InputEvent(InputEvent.Special.F6), () -> this.fileActions.localMove(panelArea, oppositePanelArea)), this.action("mkdir", ((Strings)this.app.getStrings()).actionMkdir(), new InputEvent(InputEvent.Special.F7), () -> this.fileActions.localMkdir(panelArea)), this.action("delete", ((Strings)this.app.getStrings()).actionDelete(), new InputEvent(InputEvent.Special.F8), () -> this.fileActions.localDelete(panelArea)), this.action("run", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", new InputEvent('`'), () -> this.fileActions.localRun(panelArea)), this.action("left-panel-volume", ((Strings)this.app.getStrings()).leftPanelVolume(), new InputEvent(InputEvent.Special.F1, EnumSet.of(InputEvent.Modifiers.ALT)), () -> this.actPanelVolume(this.leftPanel)), this.action("right-panel-volume", ((Strings)this.app.getStrings()).rightPanelVolume(), new InputEvent(InputEvent.Special.F2, EnumSet.of(InputEvent.Modifiers.ALT)), () -> this.actPanelVolume(this.rightPanel)), this.action("size", ((Strings)this.app.getStrings()).actionSize(), new InputEvent(InputEvent.Special.F3, EnumSet.of(InputEvent.Modifiers.CONTROL)), () -> this.fileActions.size(panelArea)), this.action("show-hidden", ((Strings)this.app.getStrings()).actionHiddenShow(), new InputEvent('='), () -> {
            panelArea.showHidden();
            this.getLuwrain().playSound(Sounds.OK);
            return true;
        }), this.action("hide-hidden", ((Strings)this.app.getStrings()).actionHiddenHide(), new InputEvent('-'), () -> {
            panelArea.hideHidden();
            this.getLuwrain().playSound(Sounds.OK);
            return true;
        })});
    }

    private boolean announcePanel(App.Side side) {
        NullCheck.notNull((Object)((Object)side), (String)"side");
        this.app.getLuwrain().playSound(Sounds.INTRO_REGULAR);
        switch (side) {
            case LEFT: {
                this.app.getLuwrain().speak(((Strings)this.app.getStrings()).leftPanelName() + " " + this.app.getLuwrain().getSpeakableText(this.leftPanel.getAreaName(), Luwrain.SpeakableTextType.PROGRAMMING));
                return true;
            }
            case RIGHT: {
                this.app.getLuwrain().speak(((Strings)this.app.getStrings()).rightPanelName() + " " + this.app.getLuwrain().getSpeakableText(this.rightPanel.getAreaName(), Luwrain.SpeakableTextType.PROGRAMMING));
                return true;
            }
        }
        return false;
    }

    private CommanderArea.ClickHandler.Result onClick(CommanderArea area, Object obj, boolean dir) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)obj, (String)"obj");
        if (dir) {
            return CommanderArea.ClickHandler.Result.OPEN_DIR;
        }
        PanelArea panelArea = (PanelArea)area;
        if (!panelArea.isLocalDir()) {
            return CommanderArea.ClickHandler.Result.REJECTED;
        }
        try {
            FileObject fileObject = (FileObject)obj;
            File file = Urls.toFile((URL)fileObject.getURL());
            this.app.getLuwrain().openFile(file.getAbsolutePath());
            return CommanderArea.ClickHandler.Result.OK;
        }
        catch (Exception e) {
            this.app.getLuwrain().crash((Throwable)e);
            return CommanderArea.ClickHandler.Result.REJECTED;
        }
    }

    private boolean actPanelVolume(PanelArea panelArea) {
        File res;
        NullCheck.notNull((Object)((Object)panelArea), (String)"panelArea");
        File file = res = panelArea == this.leftPanel ? this.app.getConv().leftPanelVolume() : this.app.getConv().rightPanelVolume();
        if (res == null) {
            return true;
        }
        panelArea.open(res);
        return true;
    }

    private boolean showFilesInfo(PanelArea panelArea) {
        NullCheck.notNull((Object)((Object)panelArea), (String)"panelArea");
        FilesInfoLayout info = new FilesInfoLayout(this.app, new File[0], () -> this.app.layout(this.getAreaLayout(), (Area)panelArea));
        this.app.layout(info.getLayout());
        return true;
    }

    boolean showVolumeInfo(PanelArea area, SimpleArea propsArea) {
        FileObject fileObj;
        File opened;
        NullCheck.notNull((Object)((Object)area), (String)"area");
        NullCheck.notNull((Object)propsArea, (String)"propsArea");
        return !(area.isLocalDir() ? (opened = PanelArea.asFile((FileObject)area.opened())) == null : (fileObj = (FileObject)area.opened()) == null);
    }

    boolean onOpenFtp(PanelArea area) {
        NullCheck.notNull((Object)((Object)area), (String)"area");
        String addr = this.app.getConv().ftpAddress();
        if (addr == null) {
            return true;
        }
        area.openLocalPath(addr);
        return true;
    }

    boolean onCopyUrls(PanelArea panelArea) {
        return true;
    }
}

