/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.vk;

import com.vk.api.sdk.objects.users.UserFull;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.app.vk.Actions;
import org.luwrain.app.vk.Base;
import org.luwrain.app.vk.FollowingsArea;
import org.luwrain.app.vk.Strings;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.BackgroundSoundQuery;

abstract class SuggestionsArea
extends ListArea {
    private final Luwrain luwrain;
    private final Strings strings;
    private final Base base;
    private final Actions actions;
    private final Runnable closing;
    private FollowingsArea followingsArea = null;
    private Area defaultArea = null;

    SuggestionsArea(Luwrain luwrain, Strings strings, Base base, Actions actions, Runnable closing) {
        super(SuggestionsArea.createParams(luwrain, strings, base));
        NullCheck.notNull((Object)actions, (String)"actions");
        NullCheck.notNull((Object)closing, (String)"closing");
        this.luwrain = luwrain;
        this.strings = strings;
        this.base = base;
        this.actions = actions;
        this.closing = closing;
        this.setListClickHandler((area, index, obj) -> {
            NullCheck.notNull((Object)obj, (String)"obj");
            if (!(obj instanceof UserFull)) {
                return false;
            }
            UserFull user = (UserFull)obj;
            return actions.onNewFriendship(user.getId(), () -> {
                this.refresh();
                this.followingsArea.refresh();
                luwrain.playSound(Sounds.OK);
            });
        });
    }

    abstract boolean onProperties(UserFull var1);

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case TAB: {
                    if (this.defaultArea == null) {
                        return false;
                    }
                    this.luwrain.setActiveArea(this.defaultArea);
                    return true;
                }
                case BACKSPACE: {
                    if (this.followingsArea == null) {
                        return false;
                    }
                    this.luwrain.setActiveArea((Area)this.followingsArea);
                    return true;
                }
                case ESCAPE: {
                    this.closing.run();
                    return true;
                }
            }
        }
        return super.onInputEvent(event);
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case PROPERTIES: {
                Object obj = this.selected();
                if (obj == null || !(obj instanceof UserFull)) {
                    return false;
                }
                return this.onProperties((UserFull)obj);
            }
            case CLOSE: {
                this.base.closeApp();
                return true;
            }
        }
        return super.onSystemEvent(event);
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 7: {
                if (this.base.isBusy()) {
                    ((BackgroundSoundQuery)query).answer(new BackgroundSoundQuery.Answer(BkgSounds.FETCHING));
                    return true;
                }
                return false;
            }
        }
        return super.onAreaQuery(query);
    }

    public Action[] getAreaActions() {
        return this.actions.lists.getSuggestionsActions();
    }

    void setFollowingsArea(FollowingsArea followingsArea) {
        NullCheck.notNull((Object)((Object)followingsArea), (String)"followingsArea");
        if (this.followingsArea != null) {
            throw new RuntimeException("followingsArea already set");
        }
        this.followingsArea = followingsArea;
    }

    void setDefaultArea(Area defaultArea) {
        NullCheck.notNull((Object)defaultArea, (String)"defaultArea");
        if (this.defaultArea != null) {
            throw new RuntimeException("defaultArea already set");
        }
        this.defaultArea = defaultArea;
    }

    private static ListArea.Params createParams(Luwrain luwrain, Strings strings, Base base) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        NullCheck.notNull((Object)base, (String)"base");
        ListArea.Params params = new ListArea.Params();
        params.context = new DefaultControlContext(luwrain);
        params.model = new Model(base);
        params.appearance = new Appearance(luwrain, strings, base);
        params.name = strings.suggestionsAreaName();
        return params;
    }

    private static final class Model
    implements ListArea.Model {
        private final Base base;

        Model(Base base) {
            NullCheck.notNull((Object)base, (String)"base");
            this.base = base;
        }

        public int getItemCount() {
            NullCheck.notNullItems((Object[])this.base.suggestions, (String)"base.suggestions");
            return this.base.suggestions.length;
        }

        public Object getItem(int index) {
            NullCheck.notNullItems((Object[])this.base.suggestions, (String)"base.suggestions");
            return this.base.suggestions[index];
        }

        public void refresh() {
        }
    }

    private static final class Appearance
    implements ListArea.Appearance<Object> {
        private final Luwrain luwrain;
        private final Strings strings;
        private final Base base;

        Appearance(Luwrain luwrain, Strings strings, Base base) {
            NullCheck.notNull((Object)luwrain, (String)"luwrain");
            NullCheck.notNull((Object)strings, (String)"strings");
            NullCheck.notNull((Object)base, (String)"base");
            this.luwrain = luwrain;
            this.strings = strings;
            this.base = base;
        }

        public void announceItem(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (item instanceof UserFull) {
                UserFull user = (UserFull)item;
                this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)(user.getFirstName() + " " + user.getLastName()), null));
                return;
            }
            this.luwrain.setEventResponse(DefaultEventResponse.listItem((Sounds)Sounds.LIST_ITEM, (String)item.toString(), null));
        }

        public String getScreenAppearance(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (item instanceof UserFull) {
                UserFull user = (UserFull)item;
                return user.getFirstName() + " " + user.getLastName();
            }
            return item.toString();
        }

        public int getObservableLeftBound(Object item) {
            return 0;
        }

        public int getObservableRightBound(Object item) {
            return this.getScreenAppearance(item, EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
        }
    }
}

