/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import java.util.ArrayList;
import java.util.Arrays;
import org.luwrain.inlandes.Matcher;
import org.luwrain.inlandes.RuleStatement;
import org.luwrain.inlandes.WhereStatement;

public final class WhereIterator {
    private static final int NO_REF = -1;
    private final Matcher matcher;
    private final RuleStatement rule;
    private final ArrayList<Level> levels = new ArrayList();
    private final int[] refsBegin;
    private final int[] refsEnd;

    public WhereIterator(Matcher matcher, RuleStatement rule) {
        if (matcher == null) {
            throw new NullPointerException("matcher can't be null");
        }
        if (rule == null) {
            throw new NullPointerException("rule can't be null");
        }
        this.matcher = matcher;
        this.rule = rule;
        this.levels.add(new Level(rule.getWhere().items));
        this.refsBegin = new int[10];
        this.refsEnd = new int[10];
        Arrays.fill(this.refsBegin, -1);
        Arrays.fill(this.refsEnd, -1);
        this.refsBegin[0] = matcher.tokenIndex;
    }

    WhereIterator(WhereIterator it) {
        if (it == null) {
            throw new NullPointerException("it can't be null");
        }
        if (it.matcher == null) {
            throw new NullPointerException("it.matcher can't be null");
        }
        this.matcher = it.matcher;
        this.rule = it.rule;
        this.levels.ensureCapacity(it.levels.size());
        for (Level l : it.levels) {
            this.levels.add(l.clone());
        }
        this.refsBegin = (int[])it.refsBegin.clone();
        this.refsEnd = (int[])it.refsEnd.clone();
    }

    void check() {
        Level level = this.getLevel();
        if (level.pos >= level.items.length) {
            if (this.levels.size() == 1) {
                this.matcher.success(this, this.rule, this.refsBegin, this.refsEnd);
                return;
            }
            if (level.ref != -1) {
                this.refsEnd[level.ref] = this.matcher.tokenIndex;
            }
            this.levels.remove(this.levels.size() - 1);
            this.matcher.addCurrentPos(this);
            return;
        }
        WhereStatement.Item item = level.items[level.pos];
        if (item.isOptional()) {
            WhereIterator newIt = new WhereIterator(this);
            ++newIt.getLevel().pos;
            this.matcher.addCurrentPos(newIt);
        }
        if (item instanceof WhereStatement.Alternative) {
            ++level.pos;
            WhereStatement.Alternative alt = (WhereStatement.Alternative)item;
            for (int i = 0; i < alt.items.length; ++i) {
                WhereIterator newIt = new WhereIterator(this);
                newIt.levels.add(new Level(new WhereStatement.Item[]{alt.items[i]}, item.getRef() != null ? item.getRef().num : -1));
                if (item.getRef() != null) {
                    newIt.refsBegin[item.getRef().num] = this.matcher.tokenIndex;
                }
                this.matcher.addCurrentPos(newIt);
            }
            return;
        }
        if (item instanceof WhereStatement.Block) {
            ++level.pos;
            WhereStatement.Block block = (WhereStatement.Block)item;
            this.levels.add(new Level(block.items, item.getRef() != null ? item.getRef().num : -1));
            if (item.getRef() != null) {
                this.refsBegin[item.getRef().num] = this.matcher.tokenIndex;
            }
            this.matcher.addCurrentPos(this);
            return;
        }
        if (item instanceof WhereStatement.Fixed) {
            WhereStatement.Fixed fixed = (WhereStatement.Fixed)item;
            if (!fixed.matcher.match(this.matcher.token)) {
                return;
            }
            if (item.getRef() != null) {
                this.refsBegin[item.getRef().num] = this.matcher.tokenIndex;
                this.refsEnd[item.getRef().num] = this.matcher.tokenIndex + 1;
            }
            ++level.pos;
            this.matcher.addNextPos(this);
            return;
        }
    }

    void onFinishing() {
        for (Level l : this.levels) {
            if (l.finished()) continue;
            return;
        }
        for (int i = 1; i < this.levels.size(); ++i) {
            Level l;
            l = this.levels.get(i);
            if (!l.finished() || l.ref == -1) continue;
            this.refsEnd[l.ref] = this.matcher.tokenIndex;
        }
        this.matcher.success(this, this.rule, this.refsBegin, this.refsEnd);
    }

    private Level getLevel() {
        return this.levels.get(this.levels.size() - 1);
    }

    private static final class Level {
        final WhereStatement.Item[] items;
        int pos;
        final int ref;

        Level(WhereStatement.Item[] items, int pos, int ref) {
            this.items = items;
            this.pos = pos;
            this.ref = ref;
        }

        Level(WhereStatement.Item[] items, int ref) {
            this(items, 0, ref);
        }

        Level(WhereStatement.Item[] items) {
            this(items, 0, -1);
        }

        boolean finished() {
            if (this.pos >= this.items.length) {
                return true;
            }
            for (int i = this.pos; i < this.items.length; ++i) {
                if (this.items[i].isOptional()) continue;
                return false;
            }
            return true;
        }

        public Level clone() {
            return new Level(this.items, this.pos, this.ref);
        }
    }
}

