/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.studio;

import java.io.IOException;
import java.util.ArrayList;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.studio.App;
import org.luwrain.app.studio.ProjectTreeModel;
import org.luwrain.app.studio.Strings;
import org.luwrain.controls.TreeListArea;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.studio.Editing;
import org.luwrain.studio.Part;

public final class ProjectBaseLayout
extends LayoutBase
implements TreeListArea.LeafClickHandler<Part> {
    static final InputEvent KEY_TREE_TOGGLE = new InputEvent(InputEvent.Special.F5);
    private final App app;
    final TreeListArea treeArea;

    ProjectBaseLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        TreeListArea.Params params = new TreeListArea.Params();
        params.context = this.getControlContext();
        params.model = new ProjectTreeModel(app);
        params.name = ((Strings)app.getStrings()).treeAreaName();
        params.leafClickHandler = this;
        this.treeArea = new TreeListArea<Part>(params){

            public boolean onInputEvent(InputEvent event) {
                if (event.equals(KEY_TREE_TOGGLE)) {
                    if (app.getTextEditingLayout() == null) {
                        return false;
                    }
                    app.getTextEditingLayout().activateEditArea(true);
                    return true;
                }
                return super.onInputEvent(event);
            }

            public boolean onSystemEvent(SystemEvent event) {
                NullCheck.notNull((Object)event, (String)"event");
                if (event.getType() == SystemEvent.Type.REGULAR && event.getCode() == SystemEvent.Code.ACTION) {
                    Part.Action[] actions;
                    ActionEvent actionEvent = (ActionEvent)event;
                    String actionName = actionEvent.getActionName();
                    Object obj = ProjectBaseLayout.this.treeArea.selected();
                    if (obj == null || !(obj instanceof Part)) {
                        return false;
                    }
                    Part part = (Part)obj;
                    for (Part.Action a : actions = part.getActions()) {
                        if (!a.getId().equals(actionName)) continue;
                        return a.onAction(app.ide);
                    }
                    return false;
                }
                return super.onSystemEvent(event);
            }

            public Action[] getAreaActions() {
                Object obj = ProjectBaseLayout.this.treeArea.selected();
                if (obj == null || !(obj instanceof Part)) {
                    return new Action[0];
                }
                Part part = (Part)obj;
                Part.Action[] actions = part.getActions();
                ArrayList<Action> res = new ArrayList<Action>();
                for (Part.Action a : actions) {
                    Action action = a.getHotKey() != null ? new Action(a.getId(), a.getTitle(), a.getHotKey()) : new Action(a.getId(), a.getTitle());
                    res.add(action);
                }
                return res.toArray(new Action[res.size()]);
            }
        };
        this.setAreaLayout((Area)this.treeArea, null);
    }

    public boolean onLeafClick(TreeListArea<Part> area, Part part) {
        try {
            Editing editing = part.startEditing();
            if (editing == null) {
                return false;
            }
            this.app.startEditing(editing);
            return true;
        }
        catch (IOException e) {
            this.app.crash(e);
            return true;
        }
    }

    protected boolean activateEditArea(boolean closeTree) {
        return false;
    }
}

