/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.studio;

import java.util.Arrays;
import org.luwrain.app.studio.App;
import org.luwrain.controls.TreeListArea;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Part;

final class ProjectTreeModel
implements TreeListArea.Model<Part> {
    final App app;

    ProjectTreeModel(App app) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        this.app = app;
    }

    public Part getRoot() {
        return this.app.getProject().getPartsRoot();
    }

    public boolean getItems(Part part, TreeListArea.Collector<Part> collector) {
        NullCheck.notNull((Object)part, (String)"part");
        NullCheck.notNull(collector, (String)"collector");
        Part[] c = part.getChildParts();
        if (c == null || c.length == 0) {
            return false;
        }
        collector.collect(Arrays.asList(c));
        return true;
    }

    public boolean isLeaf(Part part) {
        NullCheck.notNull((Object)part, (String)"part");
        Part[] c = part.getChildParts();
        return c == null || c.length == 0;
    }
}

