/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.luwrain.app.studio.Strings;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Project;
import org.luwrain.studio.ProjectType;
import org.luwrain.studio.ProjectWizard;
import org.luwrain.studio.backends.tex.TexProject;
import org.luwrain.util.FileUtils;

public final class ProjectFactory {
    private final IDE ide;
    private final Strings strings;

    public ProjectFactory(IDE ide, Strings strings) {
        this.ide = Objects.requireNonNull(ide, "ide can't be null");
        this.strings = strings;
    }

    public ProjectType[] getNewProjectTypes() {
        return new ProjectType[]{new ProjectType("java-console", 0, this.strings.projTypeJavaConsole()), new ProjectType("tex-presentation", 0, this.strings.projTypeTexPresentation()), new ProjectType("tex-article", 0, this.strings.projTypeTexArticle()), new ProjectType("lilypond-piano", 0, "\u0424\u043e\u0440\u0442\u0435\u043f\u0438\u0430\u043d\u043d\u0430\u044f \u043f\u044c\u0435\u0441\u0430 Lilypond")};
    }

    public void create(String projType, File destDir) {
        ProjectWizard w = new ProjectWizard(this.ide, this.strings, destDir, projType + ".groovy");
        this.ide.showWizard(w);
        this.ide.getLuwrainObj().announceActiveArea();
    }

    private Project readProjectKey(File projFile) throws IOException {
        String text = FileUtils.readTextFileSingleString((File)projFile, (String)"UTF-8");
        if (text.contains("---LUWRAIN-PROJECT-TEX---")) {
            return new TexProject();
        }
        return null;
    }
}

