/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.backends.java;

import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.backends.java.RootFolder;
import org.luwrain.studio.backends.java.SourceFile;

public final class Project
implements org.luwrain.studio.Project {
    static final String LOG_COMPONENT = "studio-java";
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="name")
    private String projName = null;
    @SerializedName(value="sources")
    private List<String> sources = null;
    private File projDir = null;
    private File projFile = null;
    private IDE ide;
    private boolean closed = false;
    private RootFolder rootFolder = null;
    private final List<SourceFile> sourceFiles = new ArrayList<SourceFile>();
    private ExecutorService executor = Executors.newFixedThreadPool(4);

    @Override
    public void close() {
        this.closed = true;
        this.executor.shutdownNow();
    }

    void prepare(IDE ide, File projFile) throws IOException {
        NullCheck.notNull((Object)ide, (String)"ide");
        NullCheck.notNull((Object)projFile, (String)"projFile");
        this.ide = ide;
        this.projFile = projFile;
        this.projDir = projFile.getParentFile();
        if (this.projDir == null) {
            this.projDir = new File(".");
        }
        if (this.projName == null || this.projName.trim().isEmpty()) {
            this.projName = "Java project";
        }
        this.loadSources();
        this.rootFolder = new RootFolder(this);
    }

    private void loadSources() throws IOException {
        for (String s : this.sources) {
            if (s == null || s.isEmpty()) continue;
            this.readSource(new File(this.projDir, s));
        }
    }

    private void readSource(File f) throws IOException {
        NullCheck.notNull((Object)f, (String)"f");
        if (f.isDirectory()) {
            File[] items = f.listFiles();
            if (items != null) {
                for (File i : items) {
                    this.readSource(i);
                }
            }
            return;
        }
        String name = f.getName();
        if (name.length() < 6 || !name.toUpperCase().endsWith(".JAVA")) {
            return;
        }
        this.sourceFiles.add(new SourceFile(this, f));
    }

    IDE getIde() {
        return this.ide;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public File getProjectDir() {
        return this.projDir;
    }

    String getName() {
        return this.projName;
    }

    Executor getExecutor() {
        return this.executor;
    }

    long getPreloadFileSizeLimit() {
        return 102400L;
    }

    SourceFile[] getSourceFiles() {
        return this.sourceFiles.toArray(new SourceFile[this.sourceFiles.size()]);
    }

    @Override
    public Part getPartsRoot() {
        return this.rootFolder;
    }

    @Override
    public Part getMainSourceFile() {
        return null;
    }

    @Override
    public Project load(File file, IDE ide) throws IOException {
        return null;
    }
}

