/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.edit.EditArea;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.core.HookContainer;
import org.luwrain.core.HotPoint;
import org.luwrain.core.Lines;
import org.luwrain.core.MutableLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.script.Hooks;
import org.luwrain.script.controls.EditAreaObj;
import org.luwrain.script.core.InputEventObj;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.TextEditing;
import org.luwrain.studio.syntax.Source;
import org.luwrain.util.FileUtils;

public abstract class TextEditingBase
implements TextEditing,
HotPoint {
    private static final Logger log = LogManager.getLogger();
    public static final String CHARSET = "UTF-8";
    protected final IDE ide;
    protected final File file;
    private int hotPointX = 0;
    private int hotPointY = 0;
    protected Source source;
    private MultilineEdit edit = null;
    private MultilineEdit.Model corrector = null;

    protected TextEditingBase(IDE ide, File file, int hotPointX, int hotPointY) {
        this.ide = ide;
        this.file = file;
        this.hotPointX = hotPointX;
        this.hotPointY = hotPointY;
    }

    protected TextEditingBase(IDE ide, File file) {
        this(ide, file, 0, 0);
    }

    public abstract MutableMarkedLines getContent();

    public abstract AtomicBoolean getModified();

    protected void load() throws IOException {
        if (!this.file.exists()) {
            log.info("The file doesn't exist, creating it on starting the edit: " + this.file.getAbsolutePath());
            FileUtils.writeTextFileSingleString((File)this.file, (String)"", (String)CHARSET);
        }
        String text = FileUtils.readTextFileSingleString((File)this.file, (String)CHARSET);
        this.source = new Source(text);
        this.getContent().setLines(this.source.getLines());
    }

    @Override
    public boolean save() throws IOException {
        if (!this.getModified().get()) {
            return false;
        }
        FileUtils.writeTextFileMultipleStrings((File)this.file, (String[])this.getContent().getLines(), (String)CHARSET, (String)System.lineSeparator());
        this.getModified().set(false);
        return true;
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }

    @Override
    public void closeEditing() {
    }

    @Override
    public void onNewHotPoint(int hotPointX, int hotPointY) {
        this.hotPointX = hotPointX;
        this.hotPointY = hotPointY;
    }

    @Override
    public AtomicBoolean getModifiedFlag() {
        return this.getModified();
    }

    @Override
    public boolean hasSameSource(Editing editing) {
        return false;
    }

    protected void setEdit(MultilineEdit edit, MutableLines lines) {
        this.edit = edit;
        this.corrector = edit.getMultilineEditModel();
    }

    protected MultilineEdit getEdit() {
        if (this.edit == null) {
            throw new IllegalStateException("The edit object isn't created");
        }
        return this.edit;
    }

    protected MultilineEdit.Model getCorrector() {
        if (this.corrector == null) {
            throw new IllegalStateException("The corrector object isn't created");
        }
        return this.corrector;
    }

    protected String[] getRegion() {
        if (this.edit == null) {
            return null;
        }
        return this.edit.getRegionText();
    }

    public int getHotPointX() {
        return this.hotPointX;
    }

    public int getHotPointY() {
        return this.hotPointY;
    }

    public Source getSourceCode() {
        return new Source((Lines)this.getContent());
    }

    protected boolean insertText(String[] text) {
        NullCheck.notNullItems((Object[])text, (String)"text");
        if (text.length == 0) {
            return true;
        }
        MultilineEdit.ModificationResult res = this.getCorrector().insertRegion(this.getHotPointX(), this.getHotPointY(), text);
        return res.isPerformed();
    }

    protected boolean insertText(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        if (text.isEmpty()) {
            return true;
        }
        return this.insertText(new String[]{text});
    }

    protected EditArea.InputEventListener createEditAreaInputEventHook() {
        return (edit, event) -> {
            MultilineEditCorrector corrector = (MultilineEditCorrector)edit.getEdit().getMultilineEditModel();
            AtomicBoolean res = new AtomicBoolean(false);
            corrector.doEditAction((lines, hotPoint) -> res.set(Hooks.chainOfResponsibilityNoExc((HookContainer)this.ide.getLuwrainObj(), (String)"luwrain.edit.input", (Object[])new Object[]{new EditAreaObj(edit, lines), new InputEventObj(event)})));
            return res.get();
        };
    }

    protected void replaceStr(String replaceExp, String replaceWith) {
        this.getContent().update(lines -> {
            for (int i = 0; i < lines.getLineCount(); ++i) {
                lines.setLine(i, lines.getLine(i).replaceAll(replaceExp, replaceWith));
            }
        });
        this.getModified().set(true);
    }

    protected MultilineEdit.Appearance getAppearance() {
        if (this.edit == null) {
            throw new IllegalStateException("No edit to get appearance");
        }
        return this.edit.getMultilineEditAppearance();
    }
}

