/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.interaction.javafx;

import com.google.auto.service.AutoService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import org.luwrain.core.EventConsumer;
import org.luwrain.core.Interaction;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OperatingSystem;
import org.luwrain.graphical.FxThread;
import org.luwrain.interaction.KeyboardHandler;
import org.luwrain.interaction.javafx.App;
import org.luwrain.interaction.javafx.ColorUtils;
import org.luwrain.interaction.javafx.ThreadControl;
import org.luwrain.util.TextUtils;

@AutoService(value={Interaction.class})
public final class JavaFxInteraction
implements Interaction {
    static final String LOG_COMPONENT = "fx";
    private static final int MIN_FONT_SIZE = 4;
    private App app = null;
    private KeyboardHandler keyboard;
    private boolean drawingInProgress = false;
    private int currentFontSize = 14;
    private String fontName = "Monospaced";
    private boolean graphicalMode = false;

    public boolean init(Interaction.Params params, OperatingSystem os) {
        Boolean res;
        NullCheck.notNull((Object)params, (String)"params");
        if (params.fontName != null && !params.fontName.trim().isEmpty()) {
            this.fontName = params.fontName;
        }
        new Thread(new ThreadControl()).start();
        this.app = ThreadControl.waitAppStart();
        FutureTask<Boolean> task = new FutureTask<Boolean>(() -> {
            this.currentFontSize = params.initialFontSize;
            int wndWidth = params.wndWidth;
            int wndHeight = params.wndHeight;
            this.app.setInteractionFont(this.createFont(this.currentFontSize), this.createFont2(this.currentFontSize));
            this.app.setColors(ColorUtils.InteractionColorToFx(params.fontColor), ColorUtils.InteractionColorToFx(params.font2Color), ColorUtils.InteractionColorToFx(params.bkgColor), ColorUtils.InteractionColorToFx(params.splitterColor));
            this.app.setMargin(params.marginLeft, params.marginTop, params.marginRight, params.marginBottom);
            this.keyboard = os.getCustomKeyboardHandler("javafx");
            this.app.getStage().addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                if (!this.graphicalMode) {
                    this.keyboard.onKeyPressed((Object)event);
                }
            });
            this.app.getStage().addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                if (!this.graphicalMode) {
                    this.keyboard.onKeyReleased((Object)event);
                }
            });
            this.app.getStage().addEventHandler(KeyEvent.KEY_TYPED, event -> {
                if (!this.graphicalMode) {
                    this.keyboard.onKeyTyped((Object)event);
                }
            });
            if (wndWidth < 0 || wndHeight < 0) {
                Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
                this.app.setUndecoratedSizeAndShow(screenSize.getWidth(), screenSize.getHeight());
            } else {
                this.app.setSizeAndShow(wndWidth, wndHeight);
            }
            return new Boolean(this.app.initTable());
        });
        Platform.runLater(task);
        try {
            res = task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Log.error((String)LOG_COMPONENT, (String)("the interaction procedure failed:" + e.getClass().getName() + ":" + e.getMessage()));
            return false;
        }
        if (res == null || !res.booleanValue()) {
            Log.error((String)LOG_COMPONENT, (String)"the interaction procedure failed (there can be more detailed log message)");
            return false;
        }
        return true;
    }

    public void close() {
    }

    public void startInputEventsAccepting(EventConsumer eventConsumer) {
        NullCheck.notNull((Object)eventConsumer, (String)"eventConsumer");
        this.keyboard.setEventConsumer(eventConsumer);
    }

    public void stopInputEventsAccepting() {
        this.keyboard.setEventConsumer(null);
    }

    public boolean setDesirableFontSize(int size) {
        Object res = FxThread.call(() -> {
            Font oldFont = this.app.getInteractionFont();
            Font oldFont2 = this.app.getInteractionFont2();
            Font probeFont = this.createFont(size);
            Font probeFont2 = this.createFont2(size);
            this.app.setInteractionFont(probeFont, probeFont2);
            if (!this.app.initTable()) {
                this.app.setInteractionFont(oldFont, oldFont2);
                return new Boolean(false);
            }
            this.currentFontSize = size;
            return new Boolean(true);
        });
        if (res == null || !(res instanceof Boolean)) {
            return false;
        }
        return (Boolean)res;
    }

    public int getFontSize() {
        return this.currentFontSize;
    }

    public int getWidthInCharacters() {
        return this.app.getTableWidth();
    }

    public int getHeightInCharacters() {
        return this.app.getTableHeight();
    }

    public void startDrawSession() {
        this.drawingInProgress = true;
    }

    public void clearRect(int left, int top, int right, int bottom) {
        this.app.clearRect(left, top, right, bottom);
    }

    public void drawText(int x, int y, String text) {
        NullCheck.notNull((Object)text, (String)"text");
        this.drawText(x, y, TextUtils.replaceIsoControlChars((String)text), false);
    }

    public void drawText(int x, int y, String text, boolean withFont2) {
        NullCheck.notNull((Object)text, (String)"text");
        this.app.putString(x, y, TextUtils.replaceIsoControlChars((String)text), withFont2);
    }

    public void endDrawSession() {
        this.drawingInProgress = false;
        if (!this.graphicalMode) {
            FxThread.runAsync(() -> this.app.paint());
        }
    }

    public void setHotPoint(int x, int y) {
        this.app.setHotPoint(x, y);
        if (!this.drawingInProgress) {
            FxThread.runAsync(() -> this.app.paint());
        }
    }

    public void drawVerticalLine(int top, int bottom, int x) {
        if (top > bottom) {
            Log.warning((String)LOG_COMPONENT, (String)("very odd vertical line: the top is greater than the bottom, " + top + ">" + bottom));
            this.app.drawVerticalLine(bottom, top, x);
        } else {
            this.app.drawVerticalLine(top, bottom, x);
        }
    }

    public void drawHorizontalLine(int left, int right, int y) {
        if (left > right) {
            Log.warning((String)LOG_COMPONENT, (String)("very odd horizontal line: the left is greater than the right, " + left + ">" + right));
            this.app.drawHorizontalLine(right, left, y);
        } else {
            this.app.drawHorizontalLine(left, right, y);
        }
    }

    public void showGraphical(Interaction.GraphicalMode graphicalMode) {
        NullCheck.notNull((Object)graphicalMode, (String)"graphicalMode");
        if (this.graphicalMode) {
            throw new IllegalStateException("Already in graphical mode");
        }
        AtomicReference ex = new AtomicReference();
        AtomicReference node = new AtomicReference();
        FxThread.runSync(() -> {
            Object obj = graphicalMode.getGraphicalObj(() -> {
                if (node.get() == null) {
                    throw new IllegalStateException("There is no node of the opened graphical mode");
                }
                FxThread.runSync(() -> {
                    this.app.remove((Node)node.get());
                    this.graphicalMode = false;
                });
            });
            if (obj == null) {
                ex.set(new NullPointerException("getGraphicalObj() returned null"));
                return;
            }
            if (!(obj instanceof Node)) {
                ex.set(new ClassCastException("getGraphicalObj() returned not an instance of javafx.scene.Node"));
                return;
            }
            node.set((Node)obj);
            this.app.putNew((Node)node.get());
            this.graphicalMode = true;
        });
        if (ex.get() != null) {
            throw (RuntimeException)ex.get();
        }
    }

    private Font createFont(int desirableFontSize) {
        Font res = Font.font((String)this.fontName, (double)desirableFontSize);
        return res;
    }

    private Font createFont2(int desirableFontSize) {
        Font res = Font.font((String)this.fontName, (FontWeight)FontWeight.BOLD, (double)desirableFontSize);
        return res;
    }
}

