/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.player;

import java.util.Map;
import org.luwrain.app.player.TrackInfo;
import org.luwrain.core.NullCheck;

final class Track {
    final String url;
    final Map<String, TrackInfo> trackInfoMap;

    Track(String url, Map<String, TrackInfo> trackInfoMap) {
        NullCheck.notEmpty((Object)url, (String)"url");
        NullCheck.notNull(trackInfoMap, (String)"trackInfoMap");
        this.url = url;
        this.trackInfoMap = trackInfoMap;
    }

    String getTitle() {
        TrackInfo info = this.trackInfoMap.get(this.url);
        if (info == null) {
            return this.url;
        }
        StringBuilder b = new StringBuilder();
        b.append(info.artist).append(" - ").append(info.title);
        return new String(b);
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Track)) {
            return false;
        }
        return this.url.equals(((Track)o).url);
    }
}

