/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.objects.messages;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.vk.api.sdk.objects.Validable;
import com.vk.api.sdk.objects.annotations.Required;
import com.vk.api.sdk.objects.messages.ChatSettings;
import com.vk.api.sdk.objects.messages.ConversationCanWrite;
import com.vk.api.sdk.objects.messages.ConversationPeer;
import com.vk.api.sdk.objects.messages.ConversationSortId;
import com.vk.api.sdk.objects.messages.ConversationSpecialServiceType;
import com.vk.api.sdk.objects.messages.Keyboard;
import com.vk.api.sdk.objects.messages.MessageRequestData;
import com.vk.api.sdk.objects.messages.OutReadBy;
import com.vk.api.sdk.objects.messages.PushSettings;
import java.util.List;
import java.util.Objects;

public class Conversation
implements Validable {
    @SerializedName(value="peer")
    @Required
    private ConversationPeer peer;
    @SerializedName(value="sort_id")
    private ConversationSortId sortId;
    @SerializedName(value="last_message_id")
    private Integer lastMessageId;
    @SerializedName(value="last_conversation_message_id")
    private Integer lastConversationMessageId;
    @SerializedName(value="in_read")
    private Integer inRead;
    @SerializedName(value="out_read")
    private Integer outRead;
    @SerializedName(value="unread_count")
    private Integer unreadCount;
    @SerializedName(value="is_marked_unread")
    private Boolean isMarkedUnread;
    @SerializedName(value="out_read_by")
    private OutReadBy outReadBy;
    @SerializedName(value="important")
    private Boolean important;
    @SerializedName(value="unanswered")
    private Boolean unanswered;
    @SerializedName(value="special_service_type")
    private ConversationSpecialServiceType specialServiceType;
    @SerializedName(value="message_request_data")
    private MessageRequestData messageRequestData;
    @SerializedName(value="mentions")
    private List<Integer> mentions;
    @SerializedName(value="current_keyboard")
    private Keyboard currentKeyboard;
    @SerializedName(value="push_settings")
    private PushSettings pushSettings;
    @SerializedName(value="can_write")
    private ConversationCanWrite canWrite;
    @SerializedName(value="chat_settings")
    private ChatSettings chatSettings;

    public ConversationPeer getPeer() {
        return this.peer;
    }

    public Conversation setPeer(ConversationPeer peer) {
        this.peer = peer;
        return this;
    }

    public ConversationSortId getSortId() {
        return this.sortId;
    }

    public Conversation setSortId(ConversationSortId sortId) {
        this.sortId = sortId;
        return this;
    }

    public Integer getLastMessageId() {
        return this.lastMessageId;
    }

    public Conversation setLastMessageId(Integer lastMessageId) {
        this.lastMessageId = lastMessageId;
        return this;
    }

    public Integer getLastConversationMessageId() {
        return this.lastConversationMessageId;
    }

    public Conversation setLastConversationMessageId(Integer lastConversationMessageId) {
        this.lastConversationMessageId = lastConversationMessageId;
        return this;
    }

    public Integer getInRead() {
        return this.inRead;
    }

    public Conversation setInRead(Integer inRead) {
        this.inRead = inRead;
        return this;
    }

    public Integer getOutRead() {
        return this.outRead;
    }

    public Conversation setOutRead(Integer outRead) {
        this.outRead = outRead;
        return this;
    }

    public Integer getUnreadCount() {
        return this.unreadCount;
    }

    public Conversation setUnreadCount(Integer unreadCount) {
        this.unreadCount = unreadCount;
        return this;
    }

    public Boolean getIsMarkedUnread() {
        return this.isMarkedUnread;
    }

    public Conversation setIsMarkedUnread(Boolean isMarkedUnread) {
        this.isMarkedUnread = isMarkedUnread;
        return this;
    }

    public OutReadBy getOutReadBy() {
        return this.outReadBy;
    }

    public Conversation setOutReadBy(OutReadBy outReadBy) {
        this.outReadBy = outReadBy;
        return this;
    }

    public Boolean getImportant() {
        return this.important;
    }

    public Conversation setImportant(Boolean important) {
        this.important = important;
        return this;
    }

    public Boolean getUnanswered() {
        return this.unanswered;
    }

    public Conversation setUnanswered(Boolean unanswered) {
        this.unanswered = unanswered;
        return this;
    }

    public ConversationSpecialServiceType getSpecialServiceType() {
        return this.specialServiceType;
    }

    public Conversation setSpecialServiceType(ConversationSpecialServiceType specialServiceType) {
        this.specialServiceType = specialServiceType;
        return this;
    }

    public MessageRequestData getMessageRequestData() {
        return this.messageRequestData;
    }

    public Conversation setMessageRequestData(MessageRequestData messageRequestData) {
        this.messageRequestData = messageRequestData;
        return this;
    }

    public List<Integer> getMentions() {
        return this.mentions;
    }

    public Conversation setMentions(List<Integer> mentions) {
        this.mentions = mentions;
        return this;
    }

    public Keyboard getCurrentKeyboard() {
        return this.currentKeyboard;
    }

    public Conversation setCurrentKeyboard(Keyboard currentKeyboard) {
        this.currentKeyboard = currentKeyboard;
        return this;
    }

    public PushSettings getPushSettings() {
        return this.pushSettings;
    }

    public Conversation setPushSettings(PushSettings pushSettings) {
        this.pushSettings = pushSettings;
        return this;
    }

    public ConversationCanWrite getCanWrite() {
        return this.canWrite;
    }

    public Conversation setCanWrite(ConversationCanWrite canWrite) {
        this.canWrite = canWrite;
        return this;
    }

    public ChatSettings getChatSettings() {
        return this.chatSettings;
    }

    public Conversation setChatSettings(ChatSettings chatSettings) {
        this.chatSettings = chatSettings;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.outRead, this.unanswered, this.unreadCount, this.outReadBy, this.canWrite, this.isMarkedUnread, this.lastConversationMessageId, this.messageRequestData, this.important, this.chatSettings, this.sortId, this.peer, this.mentions, this.currentKeyboard, this.inRead, this.lastMessageId, this.pushSettings, this.specialServiceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Conversation conversation = (Conversation)o;
        return Objects.equals(this.inRead, conversation.inRead) && Objects.equals(this.canWrite, conversation.canWrite) && Objects.equals(this.unanswered, conversation.unanswered) && Objects.equals(this.chatSettings, conversation.chatSettings) && Objects.equals(this.isMarkedUnread, conversation.isMarkedUnread) && Objects.equals(this.sortId, conversation.sortId) && Objects.equals(this.important, conversation.important) && Objects.equals(this.lastMessageId, conversation.lastMessageId) && Objects.equals(this.unreadCount, conversation.unreadCount) && Objects.equals(this.specialServiceType, conversation.specialServiceType) && Objects.equals(this.pushSettings, conversation.pushSettings) && Objects.equals(this.peer, conversation.peer) && Objects.equals(this.mentions, conversation.mentions) && Objects.equals(this.currentKeyboard, conversation.currentKeyboard) && Objects.equals(this.messageRequestData, conversation.messageRequestData) && Objects.equals(this.outRead, conversation.outRead) && Objects.equals(this.lastConversationMessageId, conversation.lastConversationMessageId) && Objects.equals(this.outReadBy, conversation.outReadBy);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder("Conversation{");
        sb.append("inRead=").append(this.inRead);
        sb.append(", canWrite=").append(this.canWrite);
        sb.append(", unanswered=").append(this.unanswered);
        sb.append(", chatSettings=").append(this.chatSettings);
        sb.append(", isMarkedUnread=").append(this.isMarkedUnread);
        sb.append(", sortId=").append(this.sortId);
        sb.append(", important=").append(this.important);
        sb.append(", lastMessageId=").append(this.lastMessageId);
        sb.append(", unreadCount=").append(this.unreadCount);
        sb.append(", specialServiceType='").append(this.specialServiceType).append("'");
        sb.append(", pushSettings=").append(this.pushSettings);
        sb.append(", peer=").append(this.peer);
        sb.append(", mentions=").append(this.mentions);
        sb.append(", currentKeyboard=").append(this.currentKeyboard);
        sb.append(", messageRequestData=").append(this.messageRequestData);
        sb.append(", outRead=").append(this.outRead);
        sb.append(", lastConversationMessageId=").append(this.lastConversationMessageId);
        sb.append(", outReadBy=").append(this.outReadBy);
        sb.append('}');
        return sb.toString();
    }
}

