/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.StringFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;

class RegexFilter
extends StringFilter {
    RegexFilter(String field, String value) {
        super(field, value);
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
        Pattern pattern = Pattern.compile(this.value);
        for (Map.Entry<NitriteId, Document> entry : documentMap.entrySet()) {
            Document document = entry.getValue();
            Object fieldValue = DocumentUtils.getFieldValue(document, this.field);
            if (fieldValue == null) continue;
            if (fieldValue instanceof String) {
                Matcher matcher = pattern.matcher((String)fieldValue);
                if (matcher.find()) {
                    nitriteIdSet.add(entry.getKey());
                }
                matcher.reset();
                continue;
            }
            throw new FilterException(ErrorMessage.errorMessage(this.field + " does not contain string value.", 4022));
        }
        return nitriteIdSet;
    }

    public String toString() {
        return "RegexFilter()";
    }
}

