/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.osm;

import java.util.List;
import org.luwrain.io.api.osm.dto.AddressDto;
import org.luwrain.io.api.osm.dto.CoordinatesDto;
import org.luwrain.io.api.osm.dto.NodeDto;
import org.luwrain.io.api.osm.dto.RelationDto;
import org.luwrain.io.api.osm.dto.WayDto;
import org.luwrain.io.api.osm.model.Address;
import org.luwrain.io.api.osm.model.Coordinates;
import org.luwrain.io.api.osm.model.Element;
import org.luwrain.io.api.osm.model.Node;
import org.luwrain.io.api.osm.model.Relation;
import org.luwrain.io.api.osm.model.Way;

public class ElementMapper {
    public static Node map(NodeDto nodeDto) {
        return new Node(nodeDto.getId(), nodeDto.getTags(), nodeDto.getLat(), nodeDto.getLon());
    }

    public static Way map(WayDto wayDto, List<Node> nodes) {
        return new Way(wayDto.getId(), wayDto.getTags(), nodes);
    }

    public static Relation map(RelationDto relationDto, List<Element> members) {
        return new Relation(relationDto.getId(), relationDto.getTags(), members);
    }

    public static Coordinates map(CoordinatesDto coordDto) {
        return new Coordinates(coordDto.getType(), coordDto.getId(), coordDto.getDisplayName(), coordDto.getLat(), coordDto.getLon(), coordDto.getBoundingBox());
    }

    public static Address map(AddressDto addressDto) {
        return new Address(addressDto.getType(), addressDto.getId(), addressDto.getDisplayName());
    }
}

