/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.yandex_gpt;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.luwrain.io.api.yandex_gpt.CompletionOptions;
import org.luwrain.io.api.yandex_gpt.Message;
import org.luwrain.io.api.yandex_gpt.Prompt;
import org.luwrain.io.api.yandex_gpt.Response;

public final class YandexGpt {
    private static final String URL_ASYNC = "https://llm.api.cloud.yandex.net/foundationModels/v1/completionAsync";
    private static final String URL_SYNC = "https://llm.api.cloud.yandex.net/foundationModels/v1/completion";
    private static final Gson gson = new Gson();
    private final String apiKey;
    private final Prompt prompt;

    public YandexGpt(String folderId, String apiKey, CompletionOptions options, List<Message> messages) {
        this.apiKey = Objects.requireNonNull(apiKey, "apiKey can't be null");
        this.prompt = new Prompt();
        this.prompt.setCompletionOptions(Objects.requireNonNull(options, "options can't be null"));
        this.prompt.setMessages(Objects.requireNonNull(messages, "messages can't be null"));
        this.prompt.setModelUri("gpt://" + Objects.requireNonNull(folderId, "folderId can't be null") + "/yandexgpt");
    }

    public Response doSync() throws IOException {
        URL url = new URL(URL_SYNC);
        StringBuilder b = new StringBuilder();
        gson.toJson((Object)this.prompt, (Appendable)b);
        byte[] postData = new String(b).getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setInstanceFollowRedirects(false);
        httpCon.setRequestMethod("POST");
        httpCon.setRequestProperty("Authorization", "Api-Key " + this.apiKey);
        httpCon.setRequestProperty("Content-Type", "application/json");
        httpCon.setRequestProperty("charset", "utf-8");
        httpCon.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        httpCon.setUseCaches(false);
        try (DataOutputStream w = new DataOutputStream(httpCon.getOutputStream());){
            w.write(postData);
            w.flush();
        }
        if (httpCon.getResponseCode() != 200) {
            throw new IllegalStateException("HTTP Code is " + httpCon.getResponseCode());
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(httpCon.getInputStream(), "UTF-8"));){
            Response response = (Response)gson.fromJson((Reader)r, Response.class);
            return response;
        }
    }
}

