/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.pdf;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.contentstream.operator.text.BeginText;
import org.apache.pdfbox.contentstream.operator.text.EndText;
import org.apache.pdfbox.contentstream.operator.text.MoveText;
import org.apache.pdfbox.contentstream.operator.text.MoveTextSetLeading;
import org.apache.pdfbox.contentstream.operator.text.NextLine;
import org.apache.pdfbox.contentstream.operator.text.SetCharSpacing;
import org.apache.pdfbox.contentstream.operator.text.SetFontAndSize;
import org.apache.pdfbox.contentstream.operator.text.SetTextHorizontalScaling;
import org.apache.pdfbox.contentstream.operator.text.SetTextLeading;
import org.apache.pdfbox.contentstream.operator.text.SetTextRenderingMode;
import org.apache.pdfbox.contentstream.operator.text.SetTextRise;
import org.apache.pdfbox.contentstream.operator.text.SetWordSpacing;
import org.apache.pdfbox.contentstream.operator.text.ShowText;
import org.apache.pdfbox.contentstream.operator.text.ShowTextAdjusted;
import org.apache.pdfbox.contentstream.operator.text.ShowTextLine;
import org.apache.pdfbox.contentstream.operator.text.ShowTextLineAndSpace;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.luwrain.core.NullCheck;
import org.luwrain.io.pdf.PdfChar;
import org.luwrain.io.pdf.PdfPage;

public final class PdfCharsExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfPage[] getChars(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        try (PDDocument document = null;){
            document = PDDocument.load((File)file);
            PdfPage[] pdfPageArray = this.processPages(document);
            return pdfPageArray;
        }
    }

    private PdfPage[] processPages(PDDocument doc) throws IOException {
        NullCheck.notNull((Object)doc, (String)"doc");
        int pageNum = 0;
        ArrayList<PdfPage> res = new ArrayList<PdfPage>();
        for (PDPage page : doc.getPages()) {
            ++pageNum;
            if (!page.hasContents()) continue;
            StreamChars chars = new StreamChars();
            chars.processPage(page);
            res.add(new PdfPage(pageNum, chars.output.toArray(new PdfChar[chars.output.size()])));
        }
        return res.toArray(new PdfPage[res.size()]);
    }

    private static final class StreamChars
    extends PDFStreamEngine {
        final List<PdfChar> output = new ArrayList<PdfChar>();

        StreamChars() {
            this.addOperator((OperatorProcessor)new BeginText());
            this.addOperator((OperatorProcessor)new Concatenate());
            this.addOperator((OperatorProcessor)new DrawObject());
            this.addOperator((OperatorProcessor)new EndText());
            this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
            this.addOperator((OperatorProcessor)new Save());
            this.addOperator((OperatorProcessor)new Restore());
            this.addOperator((OperatorProcessor)new NextLine());
            this.addOperator((OperatorProcessor)new SetCharSpacing());
            this.addOperator((OperatorProcessor)new MoveText());
            this.addOperator((OperatorProcessor)new MoveTextSetLeading());
            this.addOperator((OperatorProcessor)new SetFontAndSize());
            this.addOperator((OperatorProcessor)new ShowText());
            this.addOperator((OperatorProcessor)new ShowTextAdjusted());
            this.addOperator((OperatorProcessor)new SetTextLeading());
            this.addOperator((OperatorProcessor)new SetMatrix());
            this.addOperator((OperatorProcessor)new SetTextRenderingMode());
            this.addOperator((OperatorProcessor)new SetTextRise());
            this.addOperator((OperatorProcessor)new SetWordSpacing());
            this.addOperator((OperatorProcessor)new SetTextHorizontalScaling());
            this.addOperator((OperatorProcessor)new ShowTextLine());
            this.addOperator((OperatorProcessor)new ShowTextLineAndSpace());
        }

        protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
            AffineTransform at = textRenderingMatrix.createAffineTransform();
            at.concatenate(font.getFontMatrix().createAffineTransform());
            double x = StreamChars.getCm(at.getTranslateX());
            double y = StreamChars.getCm(at.getTranslateY());
            boolean bold = font.getName().toLowerCase().indexOf("bold") >= 0;
            this.output.add(new PdfChar(unicode != null && !unicode.isEmpty() ? unicode.charAt(0) : (char)'\u0000', x, y, bold));
        }

        private static double getCm(double pt) {
            return pt / 72.0 * 2.54;
        }
    }
}

