/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.opds;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.opds.Config;
import org.luwrain.app.opds.Conversations;
import org.luwrain.app.opds.HistoryItem;
import org.luwrain.app.opds.MainLayout;
import org.luwrain.app.opds.Opds;
import org.luwrain.app.opds.RemoteLibrary;
import org.luwrain.app.opds.Strings;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;

public final class App
extends AppBase<Strings> {
    final List<RemoteLibrary> libraries = new ArrayList<RemoteLibrary>();
    final List<Opds.Entry> entries = new ArrayList<Opds.Entry>();
    final LinkedList<HistoryItem> history = new LinkedList();
    private Config conf = null;
    private Conversations conv = null;
    private MainLayout mainLayout = null;

    public App() {
        super(Strings.class);
    }

    protected AreaLayout onAppInit() {
        this.conf = (Config)this.getLuwrain().loadConf(Config.class);
        if (this.conf == null) {
            this.conf = new Config();
        }
        this.conv = new Conversations(this);
        this.loadLibraries();
        this.mainLayout = new MainLayout(this);
        this.setAppName(((Strings)this.getStrings()).appName());
        return this.mainLayout.getAreaLayout();
    }

    boolean open(URL url) {
        TaskCancelling.TaskId taskId = this.newTaskId();
        return this.runTask(taskId, () -> {
            Opds.Result res = Opds.fetch(url);
            this.finishedTask(taskId, () -> {
                if (res.error == Opds.Result.Errors.FETCHING_PROBLEM) {
                    this.message("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0438\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u0430\u0434\u0440\u0435\u0441\u0443 \u043d\u0435 \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u043c OPDS-\u043a\u0430\u0442\u0430\u043b\u043e\u0433\u043e\u043c", Luwrain.MessageType.ERROR);
                    return;
                }
                if (res.hasEntries()) {
                    this.entries.clear();
                    this.entries.addAll(Arrays.asList(res.getEntries()));
                    this.history.add(new HistoryItem(url, res.getEntries()));
                    this.mainLayout.listArea.refresh();
                    this.mainLayout.listArea.reset(false);
                    this.mainLayout.setActiveArea((Area)this.mainLayout.listArea);
                }
            });
        });
    }

    private void loadLibraries() {
        this.libraries.clear();
        if (this.conf.libraries != null) {
            this.libraries.addAll(this.conf.libraries);
        }
        Collections.sort(this.libraries);
    }

    void saveLibraries() {
        this.conf.libraries = this.libraries;
        this.getLuwrain().saveConf((Object)this.conf);
    }

    URL opened() {
        return !this.history.isEmpty() ? this.history.getLast().url : null;
    }

    Conversations getConv() {
        return this.conv;
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }
}

